/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage;

import com.google.common.base.Charsets;

public class HttpHeaders {
    private static final String RFC_5987_ATTR_CHARS = "!#$&+-.^_`|~";

    public static String getContentDisposition(String filename, boolean showInline) {
        return String.format("%s; filename=%s; filename*=%s", showInline ? "inline" : "attachment", HttpHeaders.getRfc2616QuotedString(filename), HttpHeaders.getRfc5987ExtValue(filename));
    }

    private static String getRfc2616QuotedString(String text) {
        int codePoint;
        StringBuilder builder = new StringBuilder("\"");
        for (int i = 0; i < text.length(); i += Character.charCount(codePoint)) {
            codePoint = text.codePointAt(i);
            if (codePoint == 34) {
                builder.append("\\\"");
                continue;
            }
            if (codePoint == 92) {
                builder.append("\\\\");
                continue;
            }
            if (codePoint <= 255) {
                builder.appendCodePoint(codePoint);
                continue;
            }
            builder.append('_');
        }
        return builder.append('\"').toString();
    }

    private static String getRfc5987ExtValue(String text) {
        int len;
        StringBuilder builder = new StringBuilder("UTF-8''");
        for (int i = 0; i < text.length(); i += len) {
            int codePoint = text.codePointAt(i);
            len = Character.charCount(codePoint);
            if (codePoint >= 48 && codePoint <= 57 || codePoint >= 65 && codePoint <= 90 || codePoint >= 97 && codePoint <= 122 || RFC_5987_ATTR_CHARS.indexOf(codePoint) != -1) {
                builder.appendCodePoint(codePoint);
                continue;
            }
            for (byte b : text.substring(i, i + len).getBytes(Charsets.UTF_8)) {
                builder.append(String.format("%%%02X", b & 0xFF));
            }
        }
        return builder.toString();
    }

    private HttpHeaders() {
    }
}

