/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage;

import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClientRequest;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.InputStreamContent;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2ScopeRequirement;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import com.google.jenkins.plugins.metadata.MetadataContainer;
import com.google.jenkins.plugins.storage.AbstractUploadDescriptor;
import com.google.jenkins.plugins.storage.HttpHeaders;
import com.google.jenkins.plugins.storage.Messages;
import com.google.jenkins.plugins.storage.UploadException;
import com.google.jenkins.plugins.storage.UploadModule;
import com.google.jenkins.plugins.storage.reports.BuildGcsUploadReport;
import com.google.jenkins.plugins.storage.util.BucketPath;
import com.google.jenkins.plugins.storage.util.RetryStorageOperation;
import com.google.jenkins.plugins.storage.util.StorageUtil;
import com.google.jenkins.plugins.util.ConflictException;
import com.google.jenkins.plugins.util.Executor;
import com.google.jenkins.plugins.util.ExecutorException;
import com.google.jenkins.plugins.util.ForbiddenException;
import com.google.jenkins.plugins.util.NotFoundException;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Describable;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.io.FilenameUtils;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class AbstractUpload
implements Describable<AbstractUpload>,
ExtensionPoint,
Serializable {
    private static final Logger logger = Logger.getLogger(AbstractUpload.class.getName());
    private static final Map<String, String> CONTENT_TYPES = Stream.of({"css", "text/css"}, {"js", "application/javascript"}, {"svg", "image/svg+xml"}, {"woff2", "font/woff2"}).collect(Collectors.collectingAndThen(Collectors.toMap(data -> data[0], data -> data[1]), Collections::unmodifiableMap));
    private String pathPrefix;
    private final transient UploadModule module;
    private final String bucketNameWithVars;
    private boolean sharedPublicly;
    private boolean forFailedJobs;
    private boolean showInline;

    public AbstractUpload(String bucket, @Nullable UploadModule module) {
        this.module = module != null ? module : new UploadModule();
        this.bucketNameWithVars = (String)Preconditions.checkNotNull((Object)bucket);
    }

    public final void perform(String credentialsId, AbstractBuild<?, ?> build, TaskListener listener) throws UploadException, IOException {
        this.perform(credentialsId, (Run<?, ?>)build, build.getWorkspace(), listener);
    }

    public final void perform(String credentialsId, Run<?, ?> run, FilePath workspace, TaskListener listener) throws UploadException, IOException {
        GoogleRobotCredentials credentials = StorageUtil.lookupCredentials(credentialsId);
        if (!this.forResult(run.getResult())) {
            return;
        }
        try {
            String resolvedBucket = StorageUtil.replaceMacro(this.getBucket(), run, listener);
            BucketPath storagePrefix = new BucketPath(resolvedBucket);
            UploadSpec uploads = this.getInclusions(run, (FilePath)Preconditions.checkNotNull((Object)workspace), listener);
            if (uploads != null) {
                BuildGcsUploadReport links = BuildGcsUploadReport.of(run);
                links.addBucket(storagePrefix.getBucket());
                this.initiateUploadsAtWorkspace(credentials, run, storagePrefix, uploads, listener);
            }
        }
        catch (InterruptedException e) {
            throw new UploadException(Messages.AbstractUpload_UploadException(), e);
        }
        catch (IOException e) {
            throw new UploadException(Messages.AbstractUpload_UploadException(), e);
        }
    }

    @Nullable
    protected abstract UploadSpec getInclusions(Run<?, ?> var1, FilePath var2, TaskListener var3) throws UploadException;

    protected void annotateObject(StorageObject object, TaskListener listener) throws UploadException {
    }

    protected Map<String, String> getMetadata(Run<?, ?> run) {
        return MetadataContainer.of(run).getSerializedMetadata();
    }

    public boolean forResult(Result result) {
        if (result == null) {
            return true;
        }
        if (result == Result.SUCCESS) {
            return true;
        }
        if (result == Result.FAILURE || result == Result.UNSTABLE) {
            return this.isForFailedJobs();
        }
        return false;
    }

    public abstract String getDetails();

    protected synchronized UploadModule getModule() {
        if (this.module == null) {
            return new UploadModule();
        }
        return this.module;
    }

    public String getBucket() {
        return this.bucketNameWithVars;
    }

    @DataBoundSetter
    public void setSharedPublicly(boolean sharedPublicly) {
        this.sharedPublicly = sharedPublicly;
    }

    public boolean isSharedPublicly() {
        return this.sharedPublicly;
    }

    @DataBoundSetter
    public void setForFailedJobs(boolean forFailedJobs) {
        this.forFailedJobs = forFailedJobs;
    }

    public boolean isForFailedJobs() {
        return this.forFailedJobs;
    }

    @DataBoundSetter
    public void setShowInline(boolean showInline) {
        this.showInline = showInline;
    }

    public boolean isShowInline() {
        return this.showInline;
    }

    @DataBoundSetter
    public void setPathPrefix(@Nullable String pathPrefix) {
        if (pathPrefix != null && !((String)pathPrefix).endsWith("/")) {
            pathPrefix = (String)pathPrefix + "/";
        }
        this.pathPrefix = pathPrefix;
    }

    @Nullable
    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public static DescriptorExtensionList<AbstractUpload, AbstractUploadDescriptor> all() {
        return ((Jenkins)Preconditions.checkNotNull((Object)Jenkins.get())).getDescriptorList(AbstractUpload.class);
    }

    public AbstractUploadDescriptor getDescriptor() {
        return (AbstractUploadDescriptor)((Jenkins)Preconditions.checkNotNull((Object)Jenkins.get())).getDescriptor(this.getClass());
    }

    private void initiateUploadsAtWorkspace(GoogleRobotCredentials credentials, Run run, final BucketPath storagePrefix, final UploadSpec uploads, final TaskListener listener) throws UploadException {
        try {
            try {
                final GoogleRobotCredentials remoteCredentials = ((GoogleRobotCredentials)Preconditions.checkNotNull((Object)credentials)).forRemote((GoogleOAuth2ScopeRequirement)this.getModule().getRequirement());
                final String version = this.getModule().getVersion();
                uploads.workspace.act((Callable)new MasterToSlaveCallable<Void, UploadException>(this){
                    final /* synthetic */ AbstractUpload this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Void call() throws UploadException {
                        this.this$0.performUploads(storagePrefix.getBucket(), storagePrefix.getObject(), remoteCredentials, uploads, listener, version);
                        return null;
                    }
                });
            }
            catch (GeneralSecurityException e) {
                throw new UploadException(Messages.AbstractUpload_RemoteCredentialError(), e);
            }
            BuildGcsUploadReport report = BuildGcsUploadReport.of(run);
            for (FilePath include : uploads.inclusions) {
                report.addUpload(StorageUtil.getStrippedFilename(StorageUtil.getRelative(include, uploads.workspace), this.pathPrefix), storagePrefix);
            }
        }
        catch (IOException e) {
            throw new UploadException(Messages.AbstractUpload_ExceptionFileUpload(), e);
        }
        catch (InterruptedException e) {
            throw new UploadException(Messages.AbstractUpload_ExceptionFileUpload(), e);
        }
    }

    private void performUploads(final String bucketName, final String objectPrefix, final GoogleRobotCredentials credentials, final UploadSpec uploads, final TaskListener listener, final String version) throws UploadException {
        RetryStorageOperation.RepeatOperation<UploadException> a = new RetryStorageOperation.RepeatOperation<UploadException>(){
            private final Queue<FilePath> paths;
            private final Executor executor;
            private Storage service;
            private Bucket bucket;
            final /* synthetic */ AbstractUpload this$0;
            {
                this.this$0 = this$0;
                this.paths = new LinkedList<FilePath>(uploads.inclusions);
                this.executor = this.this$0.getModule().newExecutor();
            }

            @Override
            public void initCredentials() throws UploadException, IOException {
                this.service = this.this$0.getModule().getStorageService(credentials, version);
                this.bucket = this.this$0.getOrCreateBucket(this.service, credentials, this.executor, bucketName);
            }

            @Override
            public void act() throws UploadException, IOException, InterruptedException, ExecutorException {
                FilePath include = this.paths.peek();
                if (include == null) {
                    return;
                }
                String relativePath = StorageUtil.getRelative(include, uploads.workspace);
                String uploadedFileName = StorageUtil.getStrippedFilename(relativePath, this.this$0.pathPrefix);
                String finalName = FilenameUtils.separatorsToUnix((String)FilenameUtils.concat((String)objectPrefix, (String)uploadedFileName));
                StorageObject object = new StorageObject().setName(finalName).setContentDisposition(HttpHeaders.getContentDisposition(include.getName(), this.this$0.isShowInline())).setContentType(this.this$0.detectMIMEType(include.getName())).setSize(BigInteger.valueOf(include.length()));
                if (this.this$0.isSharedPublicly()) {
                    object.setAcl(AbstractUpload.addPublicReadAccess(AbstractUpload.getDefaultObjectAcl(this.bucket, listener)));
                }
                this.this$0.annotateObject(object, listener);
                listener.getLogger().println(this.this$0.getModule().prefix(Messages.AbstractUpload_Uploading(relativePath)));
                this.this$0.performUploadWithRetry(this.executor, this.service, this.bucket, object, include);
                this.paths.remove(include);
            }

            @Override
            public boolean moreWork() {
                return !this.paths.isEmpty();
            }
        };
        try {
            RetryStorageOperation.performRequestWithReinitCredentials(a);
        }
        catch (ForbiddenException e) {
            throw new UploadException(Messages.AbstractUpload_ForbiddenFileUpload(), e);
        }
        catch (ExecutorException e) {
            throw new UploadException(Messages.AbstractUpload_ExceptionFileUpload(), e);
        }
        catch (IOException e) {
            throw new UploadException(Messages.AbstractUpload_ExceptionFileUpload(), e);
        }
        catch (InterruptedException e) {
            throw new UploadException(Messages.AbstractUpload_ExceptionFileUpload(), e);
        }
    }

    private String detectMIMEType(String filename) {
        String extension = Files.getFileExtension((String)filename);
        if (CONTENT_TYPES.containsKey(extension)) {
            return CONTENT_TYPES.get(extension);
        }
        return URLConnection.guessContentTypeFromName(filename);
    }

    private void performUploadWithRetry(final Executor executor, final Storage service, final Bucket bucket, final StorageObject object, final FilePath include) throws ExecutorException, IOException, InterruptedException {
        RetryStorageOperation.Operation a = new RetryStorageOperation.Operation(){
            final /* synthetic */ AbstractUpload this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void act() throws IOException, InterruptedException, ExecutorException {
                try (InputStream is = include.read();){
                    Storage.Objects.Insert insertion = service.objects().insert(bucket.getName(), object, (AbstractInputStreamContent)new InputStreamContent(object.getContentType(), is));
                    MediaHttpUploader mediaUploader = insertion.getMediaHttpUploader();
                    if (mediaUploader != null) {
                        mediaUploader.setDirectUploadEnabled(true);
                    }
                    executor.execute((AbstractGoogleJsonClientRequest)insertion);
                }
            }
        };
        RetryStorageOperation.performRequestWithRetry(executor, a, this.getModule().getInsertRetryCount());
    }

    private static List<ObjectAccessControl> getDefaultObjectAcl(Bucket bucket, TaskListener listener) {
        List defaultAcl = bucket.getDefaultObjectAcl();
        if (defaultAcl == null) {
            listener.error(Messages.AbstractUpload_BucketObjectAclsError(bucket.getName()));
            return ImmutableList.of();
        }
        return defaultAcl;
    }

    private static List<ObjectAccessControl> addPublicReadAccess(List<ObjectAccessControl> defaultAcl) {
        ArrayList acl = Lists.newArrayList(defaultAcl);
        String publicEntity = "allUsers";
        boolean alreadyShared = Iterables.tryFind((Iterable)acl, (Predicate)new Predicate<ObjectAccessControl>(){

            public boolean apply(ObjectAccessControl access) {
                if (access != null) {
                    return Objects.equal((Object)access.getEntity(), (Object)"allUsers");
                }
                throw new NullPointerException(Messages.AbstractUpload_NullAccessError());
            }
        }).isPresent();
        if (!alreadyShared) {
            acl.add(new ObjectAccessControl().setEntity("allUsers").setRole("READER"));
        }
        return acl;
    }

    protected Bucket getOrCreateBucket(Storage service, GoogleRobotCredentials credentials, Executor executor, String bucketName) throws UploadException {
        try {
            try {
                return (Bucket)executor.execute((AbstractGoogleJsonClientRequest)service.buckets().get(bucketName).setProjection("full"));
            }
            catch (NotFoundException e) {
                try {
                    Bucket bucket = new Bucket().setName(bucketName);
                    bucket = (Bucket)executor.execute((AbstractGoogleJsonClientRequest)service.buckets().insert(credentials.getProjectId(), bucket).setProjection("full"));
                    return bucket;
                }
                catch (ConflictException ex) {
                    return (Bucket)executor.execute((AbstractGoogleJsonClientRequest)service.buckets().get(bucketName).setProjection("full"));
                }
            }
        }
        catch (ExecutorException e) {
            throw new UploadException(Messages.AbstractUpload_ExceptionGetBucket(bucketName), e);
        }
        catch (IOException e) {
            throw new UploadException(Messages.AbstractUpload_ExceptionGetBucket(bucketName), e);
        }
    }

    protected static class UploadSpec
    implements Serializable {
        public final FilePath workspace;
        public final Collection<FilePath> inclusions;

        public UploadSpec(FilePath workspace, List<FilePath> inclusions) {
            this.workspace = (FilePath)Preconditions.checkNotNull((Object)workspace);
            this.inclusions = Collections.unmodifiableCollection(inclusions);
        }
    }
}

