/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage;

import com.google.jenkins.plugins.storage.AbstractBucketLifecycleManager;
import com.google.jenkins.plugins.storage.AbstractUploadDescriptor;
import com.google.jenkins.plugins.storage.Messages;
import com.google.jenkins.plugins.util.Resolve;
import hudson.util.FormValidation;
import java.io.IOException;
import org.kohsuke.stapler.QueryParameter;

public abstract class AbstractBucketLifecycleManagerDescriptor
extends AbstractUploadDescriptor {
    public AbstractBucketLifecycleManagerDescriptor(Class<? extends AbstractBucketLifecycleManager> clazz) {
        super(clazz);
    }

    @Override
    public FormValidation doCheckBucketNameWithVars(@QueryParameter String bucketNameWithVars) throws IOException {
        String resolvedInput = Resolve.resolveBuiltin((String)bucketNameWithVars);
        if (!resolvedInput.startsWith("gs://")) {
            return FormValidation.error((String)Messages.AbstractUploadDescriptor_BadPrefix(resolvedInput, "gs://"));
        }
        if ((resolvedInput = resolvedInput.substring("gs://".length())).contains("/")) {
            return FormValidation.error((String)Messages.AbstractBucketLifecycleManagerDescriptor_MultiPartBucket(resolvedInput));
        }
        return super.doCheckBucketNameWithVars(bucketNameWithVars);
    }
}

