/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage.util;

import com.google.common.base.Strings;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import com.google.jenkins.plugins.storage.UploadException;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;

public class StorageUtil {
    public static String getRelative(FilePath include, FilePath workspace) throws UploadException {
        LinkedList<String> segments = new LinkedList<String>();
        while (!include.equals((Object)workspace)) {
            segments.push(include.getName());
            if (!Strings.isNullOrEmpty((String)(include = include.getParent()).getName())) continue;
            break;
        }
        return String.join((CharSequence)"/", segments);
    }

    public static String getStrippedFilename(String filename, String pathPrefix) {
        if (pathPrefix != null && filename != null && filename.startsWith(pathPrefix)) {
            return filename.substring(pathPrefix.length());
        }
        return filename;
    }

    public static String replaceMacro(String name, Run<?, ?> run, TaskListener listener) throws InterruptedException, IOException {
        if (run instanceof AbstractBuild) {
            name = Util.replaceMacro((String)name, (Map)run.getEnvironment(listener));
        }
        return name;
    }

    public static GoogleRobotCredentials lookupCredentials(String credentials) throws AbortException {
        GoogleRobotCredentials result = GoogleRobotCredentials.getById((String)credentials);
        if (result == null) {
            throw new AbortException("Unknown credentials: " + credentials);
        }
        return result;
    }
}

