/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import com.google.jenkins.plugins.storage.AbstractUpload;
import com.google.jenkins.plugins.storage.AbstractUploadDescriptor;
import com.google.jenkins.plugins.storage.Messages;
import com.google.jenkins.plugins.storage.UploadException;
import com.google.jenkins.plugins.storage.UploadModule;
import com.google.jenkins.plugins.storage.util.StorageUtil;
import com.google.jenkins.plugins.util.Resolve;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.console.PlainTextConsoleOutputStream;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class StdoutUpload
extends AbstractUpload {
    private final String logName;

    @DataBoundConstructor
    public StdoutUpload(@Nullable String bucket, @Nullable UploadModule module, String logName, @Deprecated @Nullable String bucketNameWithVars) {
        super(bucket != null ? bucket : bucketNameWithVars, module);
        this.logName = (String)Preconditions.checkNotNull((Object)logName);
    }

    public String getLogName() {
        return this.logName;
    }

    @Override
    public String getDetails() {
        return Messages.StdoutUpload_DetailsMessage(this.getLogName());
    }

    @Override
    public boolean forResult(Result result) {
        if (result == null) {
            return true;
        }
        if (result == Result.NOT_BUILT) {
            return true;
        }
        return super.forResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected AbstractUpload.UploadSpec getInclusions(Run<?, ?> run, FilePath workspace, TaskListener listener) throws UploadException {
        AbstractUpload.UploadSpec uploadSpec;
        PlainTextConsoleOutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            FilePath logDir = new FilePath(run.getLogFile()).getParent();
            String resolvedLogName = StorageUtil.replaceMacro(this.getLogName(), run, listener);
            FilePath logFile = new FilePath(logDir, resolvedLogName);
            outputStream = new PlainTextConsoleOutputStream(logFile.write());
            inputStream = run.getLogInputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            uploadSpec = new AbstractUpload.UploadSpec(logDir, (List<FilePath>)ImmutableList.of((Object)logFile));
        }
        catch (Throwable throwable) {
            try {
                Closeables.close(outputStream, (boolean)true);
                Closeables.close(inputStream, (boolean)true);
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new UploadException(Messages.AbstractUpload_IncludeException(), e);
            }
            catch (IOException e) {
                throw new UploadException(Messages.AbstractUpload_IncludeException(), e);
            }
        }
        Closeables.close((Closeable)outputStream, (boolean)true);
        Closeables.close((Closeable)inputStream, (boolean)true);
        return uploadSpec;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractUploadDescriptor {
        public DescriptorImpl() {
            this((Class<? extends StdoutUpload>)StdoutUpload.class);
        }

        public DescriptorImpl(Class<? extends StdoutUpload> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return Messages.StdoutUpload_DisplayName();
        }

        public FormValidation doCheckLogName(@QueryParameter String logName) {
            String resolvedInput = Resolve.resolveBuiltin((String)logName);
            if (resolvedInput.isEmpty()) {
                return FormValidation.error((String)Messages.StdoutUpload_LogNameRequired());
            }
            if (resolvedInput.contains("$")) {
                return FormValidation.error((String)Messages.StdoutUpload_BadChar("$", Messages.AbstractUploadDescriptor_DollarSuggest()));
            }
            return FormValidation.ok();
        }
    }
}

