/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.jenkins.plugins.credentials.domains.RequiresDomain;
import com.google.jenkins.plugins.storage.ExpiringBucketLifecycleManager;
import com.google.jenkins.plugins.storage.Messages;
import com.google.jenkins.plugins.storage.StorageScopeRequirement;
import com.google.jenkins.plugins.storage.UploadException;
import com.google.jenkins.plugins.storage.UploadModule;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

@RequiresDomain(value=StorageScopeRequirement.class)
public class ExpiringBucketLifecycleManagerStep
extends Recorder
implements SimpleBuildStep,
Serializable {
    private ExpiringBucketLifecycleManager upload;
    private final String credentialsId;

    @DataBoundConstructor
    public ExpiringBucketLifecycleManagerStep(String credentialsId, String bucket, Integer ttl) {
        this(credentialsId, bucket, Optional.ofNullable(null), ttl);
    }

    public ExpiringBucketLifecycleManagerStep(String credentialsId, String bucket, Optional<UploadModule> module, Integer ttl) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)credentialsId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucket) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)ttl);
        this.credentialsId = credentialsId;
        this.upload = new ExpiringBucketLifecycleManager(bucket, module.orElse(null), ttl, null, null);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getBucket() {
        return this.upload.getBucket();
    }

    public int getTtl() {
        return this.upload.getTtl();
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException {
        try {
            this.upload.perform(this.getCredentialsId(), run, workspace, listener);
        }
        catch (UploadException e) {
            throw new IOException(Messages.ExpiringBucketLifecycleManager_FailToSetExpiration(), e);
        }
    }

    @Extension
    @Symbol(value={"googleStorageBucketLifecycle"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return Messages.ExpiringBucketLifecycleManager_BuildStepDisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckBucket(@QueryParameter String bucket) throws IOException {
            return ExpiringBucketLifecycleManager.DescriptorImpl.staticDoCheckBucket(bucket);
        }
    }
}

