/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage;

import com.google.api.services.storage.model.Bucket;
import com.google.common.collect.Lists;
import com.google.jenkins.plugins.storage.AbstractBucketLifecycleManager;
import com.google.jenkins.plugins.storage.AbstractBucketLifecycleManagerDescriptor;
import com.google.jenkins.plugins.storage.InvalidAnnotationException;
import com.google.jenkins.plugins.storage.Messages;
import com.google.jenkins.plugins.storage.UploadModule;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class ExpiringBucketLifecycleManager
extends AbstractBucketLifecycleManager {
    private static final Logger logger = Logger.getLogger(ExpiringBucketLifecycleManager.class.getName());
    private final int bucketObjectTTL;
    private static final String DELETE = "Delete";

    @DataBoundConstructor
    public ExpiringBucketLifecycleManager(String bucket, @Nullable UploadModule module, Integer ttl, @Deprecated @Nullable String bucketNameWithVars, @Deprecated @Nullable Integer bucketObjectTTL) {
        super(bucket != null ? bucket : bucketNameWithVars, module);
        this.bucketObjectTTL = ttl != null ? ttl : bucketObjectTTL;
    }

    @Override
    public String getDetails() {
        return Messages.ExpiringBucketLifecycleManager_DetailsMessage(this.getTtl());
    }

    @Override
    protected Bucket checkBucket(Bucket bucket) throws InvalidAnnotationException {
        Bucket.Lifecycle lifecycle = bucket.getLifecycle();
        if (lifecycle == null) {
            throw new InvalidAnnotationException(bucket);
        }
        if (lifecycle.getRule().size() != 1) {
            if (lifecycle.getRule().size() > 1) {
                logger.log(Level.WARNING, "Found complex lifecycle rule on: " + bucket.getName());
            }
            throw new InvalidAnnotationException(bucket);
        }
        for (Bucket.Lifecycle.Rule rule : lifecycle.getRule()) {
            Integer age;
            Bucket.Lifecycle.Rule.Condition condition;
            if (!rule.getAction().getType().equalsIgnoreCase(DELETE) || (condition = rule.getCondition()).size() != 1 || (age = condition.getAge()) == null || age.intValue() != this.getTtl()) continue;
            return bucket;
        }
        logger.log(Level.WARNING, "Mismatched lifecycle rule on: " + bucket.getName());
        throw new InvalidAnnotationException(bucket);
    }

    @Override
    protected Bucket decorateBucket(Bucket bucket) {
        Bucket.Lifecycle.Rule rule = new Bucket.Lifecycle.Rule().setCondition(new Bucket.Lifecycle.Rule.Condition().setAge(Integer.valueOf(this.getTtl()))).setAction(new Bucket.Lifecycle.Rule.Action().setType(DELETE));
        ArrayList rules = Lists.newArrayList();
        rules.add(rule);
        bucket.setLifecycle(new Bucket.Lifecycle().setRule((List)rules));
        return bucket;
    }

    public int getTtl() {
        return this.bucketObjectTTL;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractBucketLifecycleManagerDescriptor {
        public DescriptorImpl() {
            this((Class<? extends ExpiringBucketLifecycleManager>)ExpiringBucketLifecycleManager.class);
        }

        public DescriptorImpl(Class<? extends ExpiringBucketLifecycleManager> clazz) {
            super((Class<? extends AbstractBucketLifecycleManager>)clazz);
        }

        public String getDisplayName() {
            return Messages.ExpiringBucketLifecycleManager_DisplayName();
        }
    }
}

