/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.storage;

import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClientRequest;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import com.google.jenkins.plugins.storage.AbstractBucketLifecycleManagerDescriptor;
import com.google.jenkins.plugins.storage.AbstractUpload;
import com.google.jenkins.plugins.storage.InvalidAnnotationException;
import com.google.jenkins.plugins.storage.Messages;
import com.google.jenkins.plugins.storage.UploadException;
import com.google.jenkins.plugins.storage.UploadModule;
import com.google.jenkins.plugins.util.ConflictException;
import com.google.jenkins.plugins.util.Executor;
import com.google.jenkins.plugins.util.ExecutorException;
import com.google.jenkins.plugins.util.NotFoundException;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;

public abstract class AbstractBucketLifecycleManager
extends AbstractUpload {
    public AbstractBucketLifecycleManager(String bucket, @Nullable UploadModule module) {
        super(bucket, module);
    }

    @Override
    @Nullable
    protected final AbstractUpload.UploadSpec getInclusions(Run<?, ?> run, FilePath workspace, TaskListener listener) throws UploadException {
        return new AbstractUpload.UploadSpec(workspace, (List<FilePath>)ImmutableList.of());
    }

    @Override
    protected Bucket getOrCreateBucket(Storage service, GoogleRobotCredentials credentials, Executor executor, String bucketName) throws UploadException {
        try {
            try {
                try {
                    return this.checkBucket((Bucket)executor.execute((AbstractGoogleJsonClientRequest)service.buckets().get(bucketName).setProjection("full")));
                }
                catch (NotFoundException e) {
                    try {
                        Bucket bucket = new Bucket().setName(bucketName);
                        bucket = this.decorateBucket(bucket);
                        bucket = (Bucket)executor.execute((AbstractGoogleJsonClientRequest)service.buckets().insert(credentials.getProjectId(), bucket).setProjection("full"));
                        return bucket;
                    }
                    catch (ConflictException ex) {
                        return this.checkBucket((Bucket)executor.execute((AbstractGoogleJsonClientRequest)service.buckets().get(bucketName).setProjection("full")));
                    }
                }
            }
            catch (InvalidAnnotationException nae) {
                Bucket bucket = nae.getBucket();
                bucket = this.decorateBucket(bucket);
                return (Bucket)executor.execute((AbstractGoogleJsonClientRequest)service.buckets().update(bucketName, bucket).setProjection("full"));
            }
        }
        catch (ExecutorException e) {
            throw new UploadException(Messages.AbstractUpload_ExceptionGetBucket(bucketName), e);
        }
        catch (IOException e) {
            throw new UploadException(Messages.AbstractUpload_ExceptionGetBucket(bucketName), e);
        }
    }

    protected abstract Bucket checkBucket(Bucket var1) throws InvalidAnnotationException;

    protected abstract Bucket decorateBucket(Bucket var1);

    @Override
    public AbstractBucketLifecycleManagerDescriptor getDescriptor() {
        return (AbstractBucketLifecycleManagerDescriptor)((Jenkins)Preconditions.checkNotNull((Object)Jenkins.get())).getDescriptor(this.getClass());
    }
}

