// CHECKSTYLE:OFF

package com.google.jenkins.plugins.storage;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Download.Downloading}: {@code Downloading: {0} to local
     * path: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Downloading: {0} to local path: {1}}
     */
    public static String Download_Downloading(Object arg0, Object arg1) {
        return holder.format("Download.Downloading", arg0, arg1);
    }

    /**
     * Key {@code Download.Downloading}: {@code Downloading: {0} to local
     * path: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Downloading: {0} to local path: {1}}
     */
    public static Localizable _Download_Downloading(Object arg0, Object arg1) {
        return new Localizable(holder, "Download.Downloading", arg0, arg1);
    }

    /**
     * Key {@code AbstractUpload.ExceptionGetBucket}: {@code exception
     * fetching/creating bucket: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code exception fetching/creating bucket: {0}}
     */
    public static String AbstractUpload_ExceptionGetBucket(Object arg0) {
        return holder.format("AbstractUpload.ExceptionGetBucket", arg0);
    }

    /**
     * Key {@code AbstractUpload.ExceptionGetBucket}: {@code exception
     * fetching/creating bucket: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code exception fetching/creating bucket: {0}}
     */
    public static Localizable _AbstractUpload_ExceptionGetBucket(Object arg0) {
        return new Localizable(holder, "AbstractUpload.ExceptionGetBucket", arg0);
    }

    /**
     * Key {@code ExpiringBucketLifecycleManager.DisplayName}: {@code Bucket
     * with expiring elements lifecycle}.
     * 
     * @return
     *     {@code Bucket with expiring elements lifecycle}
     */
    public static String ExpiringBucketLifecycleManager_DisplayName() {
        return holder.format("ExpiringBucketLifecycleManager.DisplayName");
    }

    /**
     * Key {@code ExpiringBucketLifecycleManager.DisplayName}: {@code Bucket
     * with expiring elements lifecycle}.
     * 
     * @return
     *     {@code Bucket with expiring elements lifecycle}
     */
    public static Localizable _ExpiringBucketLifecycleManager_DisplayName() {
        return new Localizable(holder, "ExpiringBucketLifecycleManager.DisplayName");
    }

    /**
     * Key {@code Download.UnsupportedDirSuffix}: {@code Slashes after
     * wildcards are not yet supported: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Slashes after wildcards are not yet supported: {0}}
     */
    public static String Download_UnsupportedDirSuffix(Object arg0) {
        return holder.format("Download.UnsupportedDirSuffix", arg0);
    }

    /**
     * Key {@code Download.UnsupportedDirSuffix}: {@code Slashes after
     * wildcards are not yet supported: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Slashes after wildcards are not yet supported: {0}}
     */
    public static Localizable _Download_UnsupportedDirSuffix(Object arg0) {
        return new Localizable(holder, "Download.UnsupportedDirSuffix", arg0);
    }

    /**
     * Key {@code UploadModule.ExceptionStorageService}: {@code exception
     * accessing storage service}.
     * 
     * @return
     *     {@code exception accessing storage service}
     */
    public static String UploadModule_ExceptionStorageService() {
        return holder.format("UploadModule.ExceptionStorageService");
    }

    /**
     * Key {@code UploadModule.ExceptionStorageService}: {@code exception
     * accessing storage service}.
     * 
     * @return
     *     {@code exception accessing storage service}
     */
    public static Localizable _UploadModule_ExceptionStorageService() {
        return new Localizable(holder, "UploadModule.ExceptionStorageService");
    }

    /**
     * Key {@code ExpiringBucketLifecycleManager.BuildStepDisplayName}:
     * {@code Google Storage Bucket Lifecycle}.
     * 
     * @return
     *     {@code Google Storage Bucket Lifecycle}
     */
    public static String ExpiringBucketLifecycleManager_BuildStepDisplayName() {
        return holder.format("ExpiringBucketLifecycleManager.BuildStepDisplayName");
    }

    /**
     * Key {@code ExpiringBucketLifecycleManager.BuildStepDisplayName}:
     * {@code Google Storage Bucket Lifecycle}.
     * 
     * @return
     *     {@code Google Storage Bucket Lifecycle}
     */
    public static Localizable _ExpiringBucketLifecycleManager_BuildStepDisplayName() {
        return new Localizable(holder, "ExpiringBucketLifecycleManager.BuildStepDisplayName");
    }

    /**
     * Key {@code ClassicUpload.NoArtifacts}: {@code No artifacts found
     * matching pattern: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No artifacts found matching pattern: {0}}
     */
    public static String ClassicUpload_NoArtifacts(Object arg0) {
        return holder.format("ClassicUpload.NoArtifacts", arg0);
    }

    /**
     * Key {@code ClassicUpload.NoArtifacts}: {@code No artifacts found
     * matching pattern: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No artifacts found matching pattern: {0}}
     */
    public static Localizable _ClassicUpload_NoArtifacts(Object arg0) {
        return new Localizable(holder, "ClassicUpload.NoArtifacts", arg0);
    }

    /**
     * Key {@code AbstractUploadDescriptor.DollarSuggest}: {@code Possible
     * unresolved variable?}.
     * 
     * @return
     *     {@code Possible unresolved variable?}
     */
    public static String AbstractUploadDescriptor_DollarSuggest() {
        return holder.format("AbstractUploadDescriptor.DollarSuggest");
    }

    /**
     * Key {@code AbstractUploadDescriptor.DollarSuggest}: {@code Possible
     * unresolved variable?}.
     * 
     * @return
     *     {@code Possible unresolved variable?}
     */
    public static Localizable _AbstractUploadDescriptor_DollarSuggest() {
        return new Localizable(holder, "AbstractUploadDescriptor.DollarSuggest");
    }

    /**
     * Key {@code ClassicUpload.BuildStepDisplayName}: {@code Google Storage
     * Classic Upload}.
     * 
     * @return
     *     {@code Google Storage Classic Upload}
     */
    public static String ClassicUpload_BuildStepDisplayName() {
        return holder.format("ClassicUpload.BuildStepDisplayName");
    }

    /**
     * Key {@code ClassicUpload.BuildStepDisplayName}: {@code Google Storage
     * Classic Upload}.
     * 
     * @return
     *     {@code Google Storage Classic Upload}
     */
    public static Localizable _ClassicUpload_BuildStepDisplayName() {
        return new Localizable(holder, "ClassicUpload.BuildStepDisplayName");
    }

    /**
     * Key {@code UploadModule.AppName}: {@code Jenkins-GCS-Plugin}.
     * 
     * @return
     *     {@code Jenkins-GCS-Plugin}
     */
    public static String UploadModule_AppName() {
        return holder.format("UploadModule.AppName");
    }

    /**
     * Key {@code UploadModule.AppName}: {@code Jenkins-GCS-Plugin}.
     * 
     * @return
     *     {@code Jenkins-GCS-Plugin}
     */
    public static Localizable _UploadModule_AppName() {
        return new Localizable(holder, "UploadModule.AppName");
    }

    /**
     * Key {@code AbstractUpload.ExceptionFileUpload}: {@code exception
     * uploading file}.
     * 
     * @return
     *     {@code exception uploading file}
     */
    public static String AbstractUpload_ExceptionFileUpload() {
        return holder.format("AbstractUpload.ExceptionFileUpload");
    }

    /**
     * Key {@code AbstractUpload.ExceptionFileUpload}: {@code exception
     * uploading file}.
     * 
     * @return
     *     {@code exception uploading file}
     */
    public static Localizable _AbstractUpload_ExceptionFileUpload() {
        return new Localizable(holder, "AbstractUpload.ExceptionFileUpload");
    }

    /**
     * Key {@code Download.DownloadException}: {@code Exception while
     * performing download}.
     * 
     * @return
     *     {@code Exception while performing download}
     */
    public static String Download_DownloadException() {
        return holder.format("Download.DownloadException");
    }

    /**
     * Key {@code Download.DownloadException}: {@code Exception while
     * performing download}.
     * 
     * @return
     *     {@code Exception while performing download}
     */
    public static Localizable _Download_DownloadException() {
        return new Localizable(holder, "Download.DownloadException");
    }

    /**
     * Key {@code Download.FoundForPattern}: {@code Found {0} files to
     * download from pattern: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Found {0} files to download from pattern: {1}}
     */
    public static String Download_FoundForPattern(Object arg0, Object arg1) {
        return holder.format("Download.FoundForPattern", arg0, arg1);
    }

    /**
     * Key {@code Download.FoundForPattern}: {@code Found {0} files to
     * download from pattern: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Found {0} files to download from pattern: {1}}
     */
    public static Localizable _Download_FoundForPattern(Object arg0, Object arg1) {
        return new Localizable(holder, "Download.FoundForPattern", arg0, arg1);
    }

    /**
     * Key {@code AbstractGcsUploadReport.DisplayName}: {@code Google Cloud
     * Storage Upload Report}.
     * 
     * @return
     *     {@code Google Cloud Storage Upload Report}
     */
    public static String AbstractGcsUploadReport_DisplayName() {
        return holder.format("AbstractGcsUploadReport.DisplayName");
    }

    /**
     * Key {@code AbstractGcsUploadReport.DisplayName}: {@code Google Cloud
     * Storage Upload Report}.
     * 
     * @return
     *     {@code Google Cloud Storage Upload Report}
     */
    public static Localizable _AbstractGcsUploadReport_DisplayName() {
        return new Localizable(holder, "AbstractGcsUploadReport.DisplayName");
    }

    /**
     * Key {@code StorageUtil.PrefixFormat}: {@code [{0}] {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [{0}] {1}}
     */
    public static String StorageUtil_PrefixFormat(Object arg0, Object arg1) {
        return holder.format("StorageUtil.PrefixFormat", arg0, arg1);
    }

    /**
     * Key {@code StorageUtil.PrefixFormat}: {@code [{0}] {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code [{0}] {1}}
     */
    public static Localizable _StorageUtil_PrefixFormat(Object arg0, Object arg1) {
        return new Localizable(holder, "StorageUtil.PrefixFormat", arg0, arg1);
    }

    /**
     * Key {@code AbstractUpload.IncludeException}: {@code Exception while
     * resolving inclusions.}.
     * 
     * @return
     *     {@code Exception while resolving inclusions.}
     */
    public static String AbstractUpload_IncludeException() {
        return holder.format("AbstractUpload.IncludeException");
    }

    /**
     * Key {@code AbstractUpload.IncludeException}: {@code Exception while
     * resolving inclusions.}.
     * 
     * @return
     *     {@code Exception while resolving inclusions.}
     */
    public static Localizable _AbstractUpload_IncludeException() {
        return new Localizable(holder, "AbstractUpload.IncludeException");
    }

    /**
     * Key {@code Download.UnsupportedAsteriskInBucket}: {@code Wildcards in
     * bucket name are not supported: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Wildcards in bucket name are not supported: {0}}
     */
    public static String Download_UnsupportedAsteriskInBucket(Object arg0) {
        return holder.format("Download.UnsupportedAsteriskInBucket", arg0);
    }

    /**
     * Key {@code Download.UnsupportedAsteriskInBucket}: {@code Wildcards in
     * bucket name are not supported: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Wildcards in bucket name are not supported: {0}}
     */
    public static Localizable _Download_UnsupportedAsteriskInBucket(Object arg0) {
        return new Localizable(holder, "Download.UnsupportedAsteriskInBucket", arg0);
    }

    /**
     * Key {@code ClassicUpload.BadGlobChar}: {@code Invalid character in
     * pattern: {0} ({1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid character in pattern: {0} ({1})}
     */
    public static String ClassicUpload_BadGlobChar(Object arg0, Object arg1) {
        return holder.format("ClassicUpload.BadGlobChar", arg0, arg1);
    }

    /**
     * Key {@code ClassicUpload.BadGlobChar}: {@code Invalid character in
     * pattern: {0} ({1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid character in pattern: {0} ({1})}
     */
    public static Localizable _ClassicUpload_BadGlobChar(Object arg0, Object arg1) {
        return new Localizable(holder, "ClassicUpload.BadGlobChar", arg0, arg1);
    }

    /**
     * Key {@code ClassicUpload.EmptyGlob}: {@code File pattern is empty}.
     * 
     * @return
     *     {@code File pattern is empty}
     */
    public static String ClassicUpload_EmptyGlob() {
        return holder.format("ClassicUpload.EmptyGlob");
    }

    /**
     * Key {@code ClassicUpload.EmptyGlob}: {@code File pattern is empty}.
     * 
     * @return
     *     {@code File pattern is empty}
     */
    public static Localizable _ClassicUpload_EmptyGlob() {
        return new Localizable(holder, "ClassicUpload.EmptyGlob");
    }

    /**
     * Key {@code Download.BuildStepDisplayName}: {@code Google Storage
     * Download}.
     * 
     * @return
     *     {@code Google Storage Download}
     */
    public static String Download_BuildStepDisplayName() {
        return holder.format("Download.BuildStepDisplayName");
    }

    /**
     * Key {@code Download.BuildStepDisplayName}: {@code Google Storage
     * Download}.
     * 
     * @return
     *     {@code Google Storage Download}
     */
    public static Localizable _Download_BuildStepDisplayName() {
        return new Localizable(holder, "Download.BuildStepDisplayName");
    }

    /**
     * Key {@code AbstractUploadDescriptor.BadBucketChar}: {@code Invalid
     * character in bucket: {0} ({1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid character in bucket: {0} ({1})}
     */
    public static String AbstractUploadDescriptor_BadBucketChar(Object arg0, Object arg1) {
        return holder.format("AbstractUploadDescriptor.BadBucketChar", arg0, arg1);
    }

    /**
     * Key {@code AbstractUploadDescriptor.BadBucketChar}: {@code Invalid
     * character in bucket: {0} ({1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid character in bucket: {0} ({1})}
     */
    public static Localizable _AbstractUploadDescriptor_BadBucketChar(Object arg0, Object arg1) {
        return new Localizable(holder, "AbstractUploadDescriptor.BadBucketChar", arg0, arg1);
    }

    /**
     * Key {@code Download.EmptyDir}: {@code Please enter the local directory
     * to store the files}.
     * 
     * @return
     *     {@code Please enter the local directory to store the files}
     */
    public static String Download_EmptyDir() {
        return holder.format("Download.EmptyDir");
    }

    /**
     * Key {@code Download.EmptyDir}: {@code Please enter the local directory
     * to store the files}.
     * 
     * @return
     *     {@code Please enter the local directory to store the files}
     */
    public static Localizable _Download_EmptyDir() {
        return new Localizable(holder, "Download.EmptyDir");
    }

    /**
     * Key {@code AbstractUpload.ForbiddenFileUpload}: {@code You aren't
     * authorized to upload files to this bucket.}.
     * 
     * @return
     *     {@code You aren't authorized to upload files to this bucket.}
     */
    public static String AbstractUpload_ForbiddenFileUpload() {
        return holder.format("AbstractUpload.ForbiddenFileUpload");
    }

    /**
     * Key {@code AbstractUpload.ForbiddenFileUpload}: {@code You aren't
     * authorized to upload files to this bucket.}.
     * 
     * @return
     *     {@code You aren't authorized to upload files to this bucket.}
     */
    public static Localizable _AbstractUpload_ForbiddenFileUpload() {
        return new Localizable(holder, "AbstractUpload.ForbiddenFileUpload");
    }

    /**
     * Key {@code ExpiringBucketLifecycleManager.DetailsMessage}: {@code
     * Contents expire in {0} days}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Contents expire in {0} days}
     */
    public static String ExpiringBucketLifecycleManager_DetailsMessage(Object arg0) {
        return holder.format("ExpiringBucketLifecycleManager.DetailsMessage", arg0);
    }

    /**
     * Key {@code ExpiringBucketLifecycleManager.DetailsMessage}: {@code
     * Contents expire in {0} days}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Contents expire in {0} days}
     */
    public static Localizable _ExpiringBucketLifecycleManager_DetailsMessage(Object arg0) {
        return new Localizable(holder, "ExpiringBucketLifecycleManager.DetailsMessage", arg0);
    }

    /**
     * Key {@code ExpiringBucketLifecycleManager.FailToSetExpiration}: {@code
     * Could not configure time to live for bucket}.
     * 
     * @return
     *     {@code Could not configure time to live for bucket}
     */
    public static String ExpiringBucketLifecycleManager_FailToSetExpiration() {
        return holder.format("ExpiringBucketLifecycleManager.FailToSetExpiration");
    }

    /**
     * Key {@code ExpiringBucketLifecycleManager.FailToSetExpiration}: {@code
     * Could not configure time to live for bucket}.
     * 
     * @return
     *     {@code Could not configure time to live for bucket}
     */
    public static Localizable _ExpiringBucketLifecycleManager_FailToSetExpiration() {
        return new Localizable(holder, "ExpiringBucketLifecycleManager.FailToSetExpiration");
    }

    /**
     * Key {@code AbstractUpload.Uploading}: {@code Uploading: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Uploading: {0}}
     */
    public static String AbstractUpload_Uploading(Object arg0) {
        return holder.format("AbstractUpload.Uploading", arg0);
    }

    /**
     * Key {@code AbstractUpload.Uploading}: {@code Uploading: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Uploading: {0}}
     */
    public static Localizable _AbstractUpload_Uploading(Object arg0) {
        return new Localizable(holder, "AbstractUpload.Uploading", arg0);
    }

    /**
     * Key {@code StdoutUpload.BuildStepDisplayName}: {@code Google Storage
     * Build Log Upload}.
     * 
     * @return
     *     {@code Google Storage Build Log Upload}
     */
    public static String StdoutUpload_BuildStepDisplayName() {
        return holder.format("StdoutUpload.BuildStepDisplayName");
    }

    /**
     * Key {@code StdoutUpload.BuildStepDisplayName}: {@code Google Storage
     * Build Log Upload}.
     * 
     * @return
     *     {@code Google Storage Build Log Upload}
     */
    public static Localizable _StdoutUpload_BuildStepDisplayName() {
        return new Localizable(holder, "StdoutUpload.BuildStepDisplayName");
    }

    /**
     * Key {@code StdoutUpload.FailToUpload}: {@code Could not perform build
     * log upload}.
     * 
     * @return
     *     {@code Could not perform build log upload}
     */
    public static String StdoutUpload_FailToUpload() {
        return holder.format("StdoutUpload.FailToUpload");
    }

    /**
     * Key {@code StdoutUpload.FailToUpload}: {@code Could not perform build
     * log upload}.
     * 
     * @return
     *     {@code Could not perform build log upload}
     */
    public static Localizable _StdoutUpload_FailToUpload() {
        return new Localizable(holder, "StdoutUpload.FailToUpload");
    }

    /**
     * Key {@code AbstractUpload.UploadException}: {@code Exception while
     * performing upload}.
     * 
     * @return
     *     {@code Exception while performing upload}
     */
    public static String AbstractUpload_UploadException() {
        return holder.format("AbstractUpload.UploadException");
    }

    /**
     * Key {@code AbstractUpload.UploadException}: {@code Exception while
     * performing upload}.
     * 
     * @return
     *     {@code Exception while performing upload}
     */
    public static Localizable _AbstractUpload_UploadException() {
        return new Localizable(holder, "AbstractUpload.UploadException");
    }

    /**
     * Key {@code Download.UnsupportedMultipleAsterisks}: {@code Multiple
     * asterisks in the cloud path are not yet supported: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Multiple asterisks in the cloud path are not yet supported:
     *     {0}}
     */
    public static String Download_UnsupportedMultipleAsterisks(Object arg0) {
        return holder.format("Download.UnsupportedMultipleAsterisks", arg0);
    }

    /**
     * Key {@code Download.UnsupportedMultipleAsterisks}: {@code Multiple
     * asterisks in the cloud path are not yet supported: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Multiple asterisks in the cloud path are not yet supported:
     *     {0}}
     */
    public static Localizable _Download_UnsupportedMultipleAsterisks(Object arg0) {
        return new Localizable(holder, "Download.UnsupportedMultipleAsterisks", arg0);
    }

    /**
     * Key {@code AbstractUpload.RemoteCredentialError}: {@code An error
     * occured preparing to use the provided credential remotely}.
     * 
     * @return
     *     {@code An error occured preparing to use the provided credential
     *     remotely}
     */
    public static String AbstractUpload_RemoteCredentialError() {
        return holder.format("AbstractUpload.RemoteCredentialError");
    }

    /**
     * Key {@code AbstractUpload.RemoteCredentialError}: {@code An error
     * occured preparing to use the provided credential remotely}.
     * 
     * @return
     *     {@code An error occured preparing to use the provided credential
     *     remotely}
     */
    public static Localizable _AbstractUpload_RemoteCredentialError() {
        return new Localizable(holder, "AbstractUpload.RemoteCredentialError");
    }

    /**
     * Key {@code StdoutUpload.DisplayName}: {@code Build Log Upload}.
     * 
     * @return
     *     {@code Build Log Upload}
     */
    public static String StdoutUpload_DisplayName() {
        return holder.format("StdoutUpload.DisplayName");
    }

    /**
     * Key {@code StdoutUpload.DisplayName}: {@code Build Log Upload}.
     * 
     * @return
     *     {@code Build Log Upload}
     */
    public static Localizable _StdoutUpload_DisplayName() {
        return new Localizable(holder, "StdoutUpload.DisplayName");
    }

    /**
     * Key {@code AbstractUpload.UploadError}: {@code Encountered an
     * exception during upload, attempt: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encountered an exception during upload, attempt: {0}}
     */
    public static String AbstractUpload_UploadError(Object arg0) {
        return holder.format("AbstractUpload.UploadError", arg0);
    }

    /**
     * Key {@code AbstractUpload.UploadError}: {@code Encountered an
     * exception during upload, attempt: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encountered an exception during upload, attempt: {0}}
     */
    public static Localizable _AbstractUpload_UploadError(Object arg0) {
        return new Localizable(holder, "AbstractUpload.UploadError", arg0);
    }

    /**
     * Key {@code AbstractUploadDescriptor.EmptyBucketName}: {@code Bucket
     * name is empty}.
     * 
     * @return
     *     {@code Bucket name is empty}
     */
    public static String AbstractUploadDescriptor_EmptyBucketName() {
        return holder.format("AbstractUploadDescriptor.EmptyBucketName");
    }

    /**
     * Key {@code AbstractUploadDescriptor.EmptyBucketName}: {@code Bucket
     * name is empty}.
     * 
     * @return
     *     {@code Bucket name is empty}
     */
    public static Localizable _AbstractUploadDescriptor_EmptyBucketName() {
        return new Localizable(holder, "AbstractUploadDescriptor.EmptyBucketName");
    }

    /**
     * Key {@code GoogleCloudStorageUploader.DisplayName}: {@code Google
     * Cloud Storage Plugin}.
     * 
     * @return
     *     {@code Google Cloud Storage Plugin}
     */
    public static String GoogleCloudStorageUploader_DisplayName() {
        return holder.format("GoogleCloudStorageUploader.DisplayName");
    }

    /**
     * Key {@code GoogleCloudStorageUploader.DisplayName}: {@code Google
     * Cloud Storage Plugin}.
     * 
     * @return
     *     {@code Google Cloud Storage Plugin}
     */
    public static Localizable _GoogleCloudStorageUploader_DisplayName() {
        return new Localizable(holder, "GoogleCloudStorageUploader.DisplayName");
    }

    /**
     * Key {@code AbstractUploadDescriptor.BadPrefix}: {@code Resolved
     * storage location must begin with {1}, saw: {0}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Resolved storage location must begin with {1}, saw: {0}}
     */
    public static String AbstractUploadDescriptor_BadPrefix(Object arg0, Object arg1) {
        return holder.format("AbstractUploadDescriptor.BadPrefix", arg0, arg1);
    }

    /**
     * Key {@code AbstractUploadDescriptor.BadPrefix}: {@code Resolved
     * storage location must begin with {1}, saw: {0}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Resolved storage location must begin with {1}, saw: {0}}
     */
    public static Localizable _AbstractUploadDescriptor_BadPrefix(Object arg0, Object arg1) {
        return new Localizable(holder, "AbstractUploadDescriptor.BadPrefix", arg0, arg1);
    }

    /**
     * Key {@code StdoutUpload.LogNameRequired}: {@code A log name is
     * required}.
     * 
     * @return
     *     {@code A log name is required}
     */
    public static String StdoutUpload_LogNameRequired() {
        return holder.format("StdoutUpload.LogNameRequired");
    }

    /**
     * Key {@code StdoutUpload.LogNameRequired}: {@code A log name is
     * required}.
     * 
     * @return
     *     {@code A log name is required}
     */
    public static Localizable _StdoutUpload_LogNameRequired() {
        return new Localizable(holder, "StdoutUpload.LogNameRequired");
    }

    /**
     * Key {@code StdoutUpload.BadChar}: {@code Invalid character in log
     * name: {0} ({1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid character in log name: {0} ({1})}
     */
    public static String StdoutUpload_BadChar(Object arg0, Object arg1) {
        return holder.format("StdoutUpload.BadChar", arg0, arg1);
    }

    /**
     * Key {@code StdoutUpload.BadChar}: {@code Invalid character in log
     * name: {0} ({1})}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid character in log name: {0} ({1})}
     */
    public static Localizable _StdoutUpload_BadChar(Object arg0, Object arg1) {
        return new Localizable(holder, "StdoutUpload.BadChar", arg0, arg1);
    }

    /**
     * Key {@code GoogleCloudStorageUploader.ExceptionDuringUpload}: {@code
     * Exception while uploading files: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception while uploading files: {0}}
     */
    public static String GoogleCloudStorageUploader_ExceptionDuringUpload(Object arg0) {
        return holder.format("GoogleCloudStorageUploader.ExceptionDuringUpload", arg0);
    }

    /**
     * Key {@code GoogleCloudStorageUploader.ExceptionDuringUpload}: {@code
     * Exception while uploading files: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception while uploading files: {0}}
     */
    public static Localizable _GoogleCloudStorageUploader_ExceptionDuringUpload(Object arg0) {
        return new Localizable(holder, "GoogleCloudStorageUploader.ExceptionDuringUpload", arg0);
    }

    /**
     * Key {@code AbstractUpload.NullAccessError}: {@code Null object
     * provided in access control list}.
     * 
     * @return
     *     {@code Null object provided in access control list}
     */
    public static String AbstractUpload_NullAccessError() {
        return holder.format("AbstractUpload.NullAccessError");
    }

    /**
     * Key {@code AbstractUpload.NullAccessError}: {@code Null object
     * provided in access control list}.
     * 
     * @return
     *     {@code Null object provided in access control list}
     */
    public static Localizable _AbstractUpload_NullAccessError() {
        return new Localizable(holder, "AbstractUpload.NullAccessError");
    }

    /**
     * Key {@code AbstractBucketLifecycleManagerDescriptor.MultiPartBucket}:
     * {@code Bucket name cannot contain multiple parts: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Bucket name cannot contain multiple parts: {0}}
     */
    public static String AbstractBucketLifecycleManagerDescriptor_MultiPartBucket(Object arg0) {
        return holder.format("AbstractBucketLifecycleManagerDescriptor.MultiPartBucket", arg0);
    }

    /**
     * Key {@code AbstractBucketLifecycleManagerDescriptor.MultiPartBucket}:
     * {@code Bucket name cannot contain multiple parts: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Bucket name cannot contain multiple parts: {0}}
     */
    public static Localizable _AbstractBucketLifecycleManagerDescriptor_MultiPartBucket(Object arg0) {
        return new Localizable(holder, "AbstractBucketLifecycleManagerDescriptor.MultiPartBucket", arg0);
    }

    /**
     * Key {@code ClassicUpload.FoundForPattern}: {@code Found {0} files to
     * upload from pattern: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Found {0} files to upload from pattern: {1}}
     */
    public static String ClassicUpload_FoundForPattern(Object arg0, Object arg1) {
        return holder.format("ClassicUpload.FoundForPattern", arg0, arg1);
    }

    /**
     * Key {@code ClassicUpload.FoundForPattern}: {@code Found {0} files to
     * upload from pattern: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Found {0} files to upload from pattern: {1}}
     */
    public static Localizable _ClassicUpload_FoundForPattern(Object arg0, Object arg1) {
        return new Localizable(holder, "ClassicUpload.FoundForPattern", arg0, arg1);
    }

    /**
     * Key {@code AbstractUpload.BucketObjectAclsError}: {@code Unable to
     * access the default object ACLs for bucket: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to access the default object ACLs for bucket: {0}}
     */
    public static String AbstractUpload_BucketObjectAclsError(Object arg0) {
        return holder.format("AbstractUpload.BucketObjectAclsError", arg0);
    }

    /**
     * Key {@code AbstractUpload.BucketObjectAclsError}: {@code Unable to
     * access the default object ACLs for bucket: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to access the default object ACLs for bucket: {0}}
     */
    public static Localizable _AbstractUpload_BucketObjectAclsError(Object arg0) {
        return new Localizable(holder, "AbstractUpload.BucketObjectAclsError", arg0);
    }

    /**
     * Key {@code ClassicUpload.DisplayName}: {@code Classic Upload}.
     * 
     * @return
     *     {@code Classic Upload}
     */
    public static String ClassicUpload_DisplayName() {
        return holder.format("ClassicUpload.DisplayName");
    }

    /**
     * Key {@code ClassicUpload.DisplayName}: {@code Classic Upload}.
     * 
     * @return
     *     {@code Classic Upload}
     */
    public static Localizable _ClassicUpload_DisplayName() {
        return new Localizable(holder, "ClassicUpload.DisplayName");
    }

    /**
     * Key {@code StdoutUpload.DetailsMessage}: {@code {0} (Build Log)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} (Build Log)}
     */
    public static String StdoutUpload_DetailsMessage(Object arg0) {
        return holder.format("StdoutUpload.DetailsMessage", arg0);
    }

    /**
     * Key {@code StdoutUpload.DetailsMessage}: {@code {0} (Build Log)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} (Build Log)}
     */
    public static Localizable _StdoutUpload_DetailsMessage(Object arg0) {
        return new Localizable(holder, "StdoutUpload.DetailsMessage", arg0);
    }

}
