/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.k8sengine;

import hudson.FilePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class Manifests {
    private static final String DEFAULT_ENCODING = "UTF-8";
    static Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
    private List<ManifestObject> objects = new ArrayList<ManifestObject>();

    private Manifests(FilePath filePath) throws IOException, InterruptedException {
        this(Arrays.asList(filePath));
    }

    private Manifests(List<FilePath> files) throws IOException, InterruptedException {
        for (FilePath fp : files) {
            this.loadFile(fp);
        }
    }

    public static Manifests fromFile(FilePath file) throws IOException, InterruptedException {
        if (file.isDirectory()) {
            return new Manifests(Arrays.asList(file.list("**/*")));
        }
        return new Manifests(file);
    }

    public static Manifests fromFileList(List<FilePath> files) throws IOException, InterruptedException {
        return new Manifests(files);
    }

    private void loadFile(FilePath filePath) throws IOException, InterruptedException {
        InputStream mis = filePath.read();
        Iterable iter = yaml.loadAll((Reader)new InputStreamReader(mis, DEFAULT_ENCODING));
        iter.forEach(o -> this.objects.add(new ManifestObject((Map)o, filePath)));
    }

    public List<ManifestObject> getObjectManifests() {
        return this.objects;
    }

    public List<ManifestObject> getObjectManifestsOfKinds(Set<String> includedKinds) {
        Set includedKindsLowerCase = includedKinds.stream().map(String::toLowerCase).collect(Collectors.toSet());
        return this.getObjectManifests().stream().filter(manifest -> includedKindsLowerCase.contains(manifest.getKind().toLowerCase())).collect(Collectors.toList());
    }

    public void write() throws InterruptedException, IOException {
        LinkedHashMap<FilePath, List> fileToManifestListMap = new LinkedHashMap<FilePath, List>();
        for (ManifestObject manifestObject : this.getObjectManifests()) {
            List manifestList = fileToManifestListMap.getOrDefault(manifestObject.getFile(), new ArrayList());
            manifestList.add(manifestObject);
            fileToManifestListMap.put(manifestObject.getFile(), manifestList);
        }
        for (Map.Entry entry : fileToManifestListMap.entrySet()) {
            FilePath file = (FilePath)entry.getKey();
            List manifestObjects = (List)entry.getValue();
            file.write(yaml.dumpAll(manifestObjects.stream().map(m -> m.getSource()).iterator()), DEFAULT_ENCODING);
        }
    }

    public static class ManifestObject {
        private Map<String, Object> source;
        private FilePath file;

        public ManifestObject(Map<String, Object> source, FilePath file) {
            this.source = source;
            this.file = file;
        }

        public FilePath getFile() {
            return this.file;
        }

        public Map<String, Object> getSource() {
            return this.source;
        }

        public String getApiVersion() {
            return (String)this.source.get("apiVersion");
        }

        public String getKind() {
            return (String)this.source.get("kind");
        }

        public Optional<String> getName() {
            return this.getMetadata().isPresent() ? Optional.of((String)this.getMetadata().get().get("name")) : Optional.empty();
        }

        public Map<String, String> getOrCreateLabels() {
            Map<String, Object> metadata = this.getOrCreateMetadata();
            if (!metadata.containsKey("labels")) {
                metadata.put("labels", new LinkedHashMap());
            }
            return (Map)metadata.get("labels");
        }

        public void addLabel(String key, String value) {
            Map<String, String> labels = this.getOrCreateLabels();
            HashSet<String> labelValues = labels.get(key) != null ? new HashSet<String>(Arrays.asList(labels.get(key).split(","))) : new HashSet();
            labelValues.add(value);
            labels.put(key, String.join((CharSequence)",", labelValues));
        }

        public String describe() {
            return String.format("%s/%s: %s", this.getApiVersion(), this.getKind(), this.getName().orElse(""));
        }

        private Optional<Map<String, Object>> getMetadata() {
            return Optional.ofNullable((Map)this.source.get("metadata"));
        }

        private Map<String, Object> getOrCreateMetadata() {
            if (this.source.get("metadata") == null) {
                this.source.put("metadata", new LinkedHashMap());
            }
            return (Map)this.source.get("metadata");
        }
    }
}

