/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.k8sengine;

import com.google.common.base.Preconditions;
import com.google.jenkins.plugins.k8sengine.KubectlWrapper;
import com.google.jenkins.plugins.k8sengine.KubernetesEngineBuilder;
import com.google.jenkins.plugins.k8sengine.Manifests;
import com.google.jenkins.plugins.k8sengine.Messages;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class KubernetesVerifiers {
    private static final Logger LOGGER = Logger.getLogger(KubernetesEngineBuilder.class.getName());
    private static Map<String, Verifier> verifiers = new HashMap<String, Verifier>();
    private static final Verifier defaultVerifier = new DefaultVerifier();
    public static final String DEPLOYMENT_KIND = "deployment";

    private static Verifier getKindVerifier(String kind) {
        return verifiers.get("*/" + kind.toLowerCase());
    }

    private static Verifier getVerifier(String apiVersion, String kind) {
        Verifier verifier = verifiers.get(apiVersion + "/" + kind);
        if (verifier == null && (verifier = KubernetesVerifiers.getKindVerifier(kind)) == null) {
            verifier = defaultVerifier;
        }
        return verifier;
    }

    public static VerificationResult verify(KubectlWrapper kubectl, Manifests.ManifestObject object) {
        Preconditions.checkNotNull((Object)object);
        return KubernetesVerifiers.getVerifier(object.getApiVersion(), object.getKind()).verify(kubectl, object);
    }

    private static VerificationResult errorResult(Throwable t, Manifests.ManifestObject object) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return new VerificationResult(sw.toString(), false, object);
    }

    static {
        verifiers.put("*/deployment", new DeploymentVerifier());
    }

    public static interface Verifier {
        public VerificationResult verify(KubectlWrapper var1, Manifests.ManifestObject var2);
    }

    public static class VerificationResult {
        private String log;
        private boolean status;
        private Manifests.ManifestObject manifestObject;

        private String getLog() {
            return this.log;
        }

        public boolean isVerified() {
            return this.status;
        }

        public Manifests.ManifestObject getManifestObject() {
            return this.manifestObject;
        }

        public VerificationResult(String log, boolean status, Manifests.ManifestObject object) {
            this.log = log;
            this.status = status;
            this.manifestObject = object;
        }

        public String toString() {
            return (this.status ? Messages.KubernetesEngineBuilder_VerifyingLogSuccess(this.manifestObject.describe()) : Messages.KubernetesEngineBuilder_VerifyingLogFailure(this.manifestObject.describe())) + "\n" + this.log;
        }
    }

    private static class DefaultVerifier
    implements Verifier {
        private DefaultVerifier() {
        }

        @Override
        public VerificationResult verify(KubectlWrapper kubectl, Manifests.ManifestObject object) {
            LOGGER.info("Reached unimplemented default verifier.");
            return new VerificationResult(Messages.KubernetesEngineBuilder_VerifierNotImplementedFor(object.describe()), false, object);
        }
    }

    private static class DeploymentVerifier
    implements Verifier {
        private static final String STATUS_JSONPATH = "status";
        private static final String AVAILABLE_REPLICAS = "availableReplicas";
        private static final String UPDATED_REPLICAS = "updatedReplicas";
        private static final String REPLICAS = "replicas";
        private static final String DESIRED_REPLICAS_JSONPATH = "spec.replicas";

        private DeploymentVerifier() {
        }

        @Override
        public VerificationResult verify(KubectlWrapper kubectl, Manifests.ManifestObject object) {
            Preconditions.checkArgument((boolean)object.getName().isPresent());
            String name = object.getName().get();
            LOGGER.info(String.format("Verifying deployment, %s", name));
            StringBuilder log = new StringBuilder();
            Object json = null;
            try {
                json = kubectl.getObject(object.getKind().toLowerCase(), name);
            }
            catch (Exception e) {
                return KubernetesVerifiers.errorResult(e, object);
            }
            Integer desiredReplicas = (Integer)JsonPath.read((Object)json, (String)DESIRED_REPLICAS_JSONPATH, (Predicate[])new Predicate[0]);
            Map status = (Map)JsonPath.read((Object)json, (String)STATUS_JSONPATH, (Predicate[])new Predicate[0]);
            Integer availableReplicas = status.getOrDefault(AVAILABLE_REPLICAS, 0);
            Integer updatedReplicas = status.getOrDefault(UPDATED_REPLICAS, 0);
            Integer replicas = status.getOrDefault(REPLICAS, 0);
            boolean verified = desiredReplicas != null && updatedReplicas >= desiredReplicas && replicas <= updatedReplicas && availableReplicas.intValue() == updatedReplicas.intValue();
            log.append("AvailableReplicas = ").append(availableReplicas).append(",").append(" UpdatedReplicas = ").append(updatedReplicas).append(",").append(" DesiredReplicas = ").append(desiredReplicas).append("\n");
            return new VerificationResult(log.toString(), verified, object);
        }
    }
}

