// CHECKSTYLE:OFF

package com.google.jenkins.plugins.k8sengine;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code KubernetesEngineBuilder.ProjectIDFillError}: {@code Error
     * retrieving Project IDs from CloudResourceManager}.
     * 
     * @return
     *     {@code Error retrieving Project IDs from CloudResourceManager}
     */
    public static String KubernetesEngineBuilder_ProjectIDFillError() {
        return holder.format("KubernetesEngineBuilder.ProjectIDFillError");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ProjectIDFillError}: {@code Error
     * retrieving Project IDs from CloudResourceManager}.
     * 
     * @return
     *     {@code Error retrieving Project IDs from CloudResourceManager}
     */
    public static Localizable _KubernetesEngineBuilder_ProjectIDFillError() {
        return new Localizable(holder, "KubernetesEngineBuilder.ProjectIDFillError");
    }

    /**
     * Key {@code KubernetesEngineBuilder.VerifyingLogSuccess}: {@code
     * Successfully verified {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Successfully verified {0}}
     */
    public static String KubernetesEngineBuilder_VerifyingLogSuccess(Object arg0) {
        return holder.format("KubernetesEngineBuilder.VerifyingLogSuccess", arg0);
    }

    /**
     * Key {@code KubernetesEngineBuilder.VerifyingLogSuccess}: {@code
     * Successfully verified {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Successfully verified {0}}
     */
    public static Localizable _KubernetesEngineBuilder_VerifyingLogSuccess(Object arg0) {
        return new Localizable(holder, "KubernetesEngineBuilder.VerifyingLogSuccess", arg0);
    }

    /**
     * Key {@code KubernetesEngineBuilder.VerifierNotImplementedFor}: {@code
     * Verifier not implemented for {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Verifier not implemented for {0}}
     */
    public static String KubernetesEngineBuilder_VerifierNotImplementedFor(Object arg0) {
        return holder.format("KubernetesEngineBuilder.VerifierNotImplementedFor", arg0);
    }

    /**
     * Key {@code KubernetesEngineBuilder.VerifierNotImplementedFor}: {@code
     * Verifier not implemented for {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Verifier not implemented for {0}}
     */
    public static Localizable _KubernetesEngineBuilder_VerifierNotImplementedFor(Object arg0) {
        return new Localizable(holder, "KubernetesEngineBuilder.VerifierNotImplementedFor", arg0);
    }

    /**
     * Key {@code KubernetesEngineBuilder.ClusterFillError}: {@code Error
     * retrieving clusters from GKE}.
     * 
     * @return
     *     {@code Error retrieving clusters from GKE}
     */
    public static String KubernetesEngineBuilder_ClusterFillError() {
        return holder.format("KubernetesEngineBuilder.ClusterFillError");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ClusterFillError}: {@code Error
     * retrieving clusters from GKE}.
     * 
     * @return
     *     {@code Error retrieving clusters from GKE}
     */
    public static Localizable _KubernetesEngineBuilder_ClusterFillError() {
        return new Localizable(holder, "KubernetesEngineBuilder.ClusterFillError");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ProjectIDVerificationError}: {@code
     * Error retrieving Project IDs for verification}.
     * 
     * @return
     *     {@code Error retrieving Project IDs for verification}
     */
    public static String KubernetesEngineBuilder_ProjectIDVerificationError() {
        return holder.format("KubernetesEngineBuilder.ProjectIDVerificationError");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ProjectIDVerificationError}: {@code
     * Error retrieving Project IDs for verification}.
     * 
     * @return
     *     {@code Error retrieving Project IDs for verification}
     */
    public static Localizable _KubernetesEngineBuilder_ProjectIDVerificationError() {
        return new Localizable(holder, "KubernetesEngineBuilder.ProjectIDVerificationError");
    }

    /**
     * Key {@code KubernetesEngineBuilder.VerifyTimeoutInMinutesRequired}:
     * {@code Verification requires a timeout value}.
     * 
     * @return
     *     {@code Verification requires a timeout value}
     */
    public static String KubernetesEngineBuilder_VerifyTimeoutInMinutesRequired() {
        return holder.format("KubernetesEngineBuilder.VerifyTimeoutInMinutesRequired");
    }

    /**
     * Key {@code KubernetesEngineBuilder.VerifyTimeoutInMinutesRequired}:
     * {@code Verification requires a timeout value}.
     * 
     * @return
     *     {@code Verification requires a timeout value}
     */
    public static Localizable _KubernetesEngineBuilder_VerifyTimeoutInMinutesRequired() {
        return new Localizable(holder, "KubernetesEngineBuilder.VerifyTimeoutInMinutesRequired");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ClusterRequired}: {@code Cluster is
     * required}.
     * 
     * @return
     *     {@code Cluster is required}
     */
    public static String KubernetesEngineBuilder_ClusterRequired() {
        return holder.format("KubernetesEngineBuilder.ClusterRequired");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ClusterRequired}: {@code Cluster is
     * required}.
     * 
     * @return
     *     {@code Cluster is required}
     */
    public static Localizable _KubernetesEngineBuilder_ClusterRequired() {
        return new Localizable(holder, "KubernetesEngineBuilder.ClusterRequired");
    }

    /**
     * Key {@code KubernetesEngineBuilder.KubernetesObjectsNotVerified}:
     * {@code Kubernetes objects couldn't be verified}.
     * 
     * @return
     *     {@code Kubernetes objects couldn't be verified}
     */
    public static String KubernetesEngineBuilder_KubernetesObjectsNotVerified() {
        return holder.format("KubernetesEngineBuilder.KubernetesObjectsNotVerified");
    }

    /**
     * Key {@code KubernetesEngineBuilder.KubernetesObjectsNotVerified}:
     * {@code Kubernetes objects couldn't be verified}.
     * 
     * @return
     *     {@code Kubernetes objects couldn't be verified}
     */
    public static Localizable _KubernetesEngineBuilder_KubernetesObjectsNotVerified() {
        return new Localizable(holder, "KubernetesEngineBuilder.KubernetesObjectsNotVerified");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ManifestRequired}: {@code Manifest
     * is required}.
     * 
     * @return
     *     {@code Manifest is required}
     */
    public static String KubernetesEngineBuilder_ManifestRequired() {
        return holder.format("KubernetesEngineBuilder.ManifestRequired");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ManifestRequired}: {@code Manifest
     * is required}.
     * 
     * @return
     *     {@code Manifest is required}
     */
    public static Localizable _KubernetesEngineBuilder_ManifestRequired() {
        return new Localizable(holder, "KubernetesEngineBuilder.ManifestRequired");
    }

    /**
     * Key {@code KubernetesEngineBuilder.DisplayName}: {@code Deploy to
     * Google Kubernetes Engine}.
     * 
     * @return
     *     {@code Deploy to Google Kubernetes Engine}
     */
    public static String KubernetesEngineBuilder_DisplayName() {
        return holder.format("KubernetesEngineBuilder.DisplayName");
    }

    /**
     * Key {@code KubernetesEngineBuilder.DisplayName}: {@code Deploy to
     * Google Kubernetes Engine}.
     * 
     * @return
     *     {@code Deploy to Google Kubernetes Engine}
     */
    public static Localizable _KubernetesEngineBuilder_DisplayName() {
        return new Localizable(holder, "KubernetesEngineBuilder.DisplayName");
    }

    /**
     * Key {@code KubernetesEngineBuilder.VerifyingLogFailure}: {@code Failed
     * to verify {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to verify {0}}
     */
    public static String KubernetesEngineBuilder_VerifyingLogFailure(Object arg0) {
        return holder.format("KubernetesEngineBuilder.VerifyingLogFailure", arg0);
    }

    /**
     * Key {@code KubernetesEngineBuilder.VerifyingLogFailure}: {@code Failed
     * to verify {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to verify {0}}
     */
    public static Localizable _KubernetesEngineBuilder_VerifyingLogFailure(Object arg0) {
        return new Localizable(holder, "KubernetesEngineBuilder.VerifyingLogFailure", arg0);
    }

    /**
     * Key {@code KubernetesEngineBuilder.ClusterNotInProject}: {@code
     * Cluster does not exist in specified project}.
     * 
     * @return
     *     {@code Cluster does not exist in specified project}
     */
    public static String KubernetesEngineBuilder_ClusterNotInProject() {
        return holder.format("KubernetesEngineBuilder.ClusterNotInProject");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ClusterNotInProject}: {@code
     * Cluster does not exist in specified project}.
     * 
     * @return
     *     {@code Cluster does not exist in specified project}
     */
    public static Localizable _KubernetesEngineBuilder_ClusterNotInProject() {
        return new Localizable(holder, "KubernetesEngineBuilder.ClusterNotInProject");
    }

    /**
     * Key {@code KubernetesEngineBuilder.VerifyingLogPrefix}: {@code
     * Verifying: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Verifying: {0}}
     */
    public static String KubernetesEngineBuilder_VerifyingLogPrefix(Object arg0) {
        return holder.format("KubernetesEngineBuilder.VerifyingLogPrefix", arg0);
    }

    /**
     * Key {@code KubernetesEngineBuilder.VerifyingLogPrefix}: {@code
     * Verifying: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Verifying: {0}}
     */
    public static Localizable _KubernetesEngineBuilder_VerifyingLogPrefix(Object arg0) {
        return new Localizable(holder, "KubernetesEngineBuilder.VerifyingLogPrefix", arg0);
    }

    /**
     * Key {@code KubernetesEngineBuilder.ClusterProjectIDRequired}: {@code
     * Project ID required to validate cluster}.
     * 
     * @return
     *     {@code Project ID required to validate cluster}
     */
    public static String KubernetesEngineBuilder_ClusterProjectIDRequired() {
        return holder.format("KubernetesEngineBuilder.ClusterProjectIDRequired");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ClusterProjectIDRequired}: {@code
     * Project ID required to validate cluster}.
     * 
     * @return
     *     {@code Project ID required to validate cluster}
     */
    public static Localizable _KubernetesEngineBuilder_ClusterProjectIDRequired() {
        return new Localizable(holder, "KubernetesEngineBuilder.ClusterProjectIDRequired");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ClusterVerificationError}: {@code
     * Error retrieving clusters for verification}.
     * 
     * @return
     *     {@code Error retrieving clusters for verification}
     */
    public static String KubernetesEngineBuilder_ClusterVerificationError() {
        return holder.format("KubernetesEngineBuilder.ClusterVerificationError");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ClusterVerificationError}: {@code
     * Error retrieving clusters for verification}.
     * 
     * @return
     *     {@code Error retrieving clusters for verification}
     */
    public static Localizable _KubernetesEngineBuilder_ClusterVerificationError() {
        return new Localizable(holder, "KubernetesEngineBuilder.ClusterVerificationError");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ProjectIDRequired}: {@code Project
     * ID is required}.
     * 
     * @return
     *     {@code Project ID is required}
     */
    public static String KubernetesEngineBuilder_ProjectIDRequired() {
        return holder.format("KubernetesEngineBuilder.ProjectIDRequired");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ProjectIDRequired}: {@code Project
     * ID is required}.
     * 
     * @return
     *     {@code Project ID is required}
     */
    public static Localizable _KubernetesEngineBuilder_ProjectIDRequired() {
        return new Localizable(holder, "KubernetesEngineBuilder.ProjectIDRequired");
    }

    /**
     * Key {@code KubernetesEngineBuilder.VerifyTimeoutInMinutesFormatError}:
     * {@code Verification timeout value must be an integer}.
     * 
     * @return
     *     {@code Verification timeout value must be an integer}
     */
    public static String KubernetesEngineBuilder_VerifyTimeoutInMinutesFormatError() {
        return holder.format("KubernetesEngineBuilder.VerifyTimeoutInMinutesFormatError");
    }

    /**
     * Key {@code KubernetesEngineBuilder.VerifyTimeoutInMinutesFormatError}:
     * {@code Verification timeout value must be an integer}.
     * 
     * @return
     *     {@code Verification timeout value must be an integer}
     */
    public static Localizable _KubernetesEngineBuilder_VerifyTimeoutInMinutesFormatError() {
        return new Localizable(holder, "KubernetesEngineBuilder.VerifyTimeoutInMinutesFormatError");
    }

    /**
     * Key {@code KubernetesEngineBuilder.NamespaceInvalid}: {@code Namespace
     * is not properly formed, see help for details}.
     * 
     * @return
     *     {@code Namespace is not properly formed, see help for details}
     */
    public static String KubernetesEngineBuilder_NamespaceInvalid() {
        return holder.format("KubernetesEngineBuilder.NamespaceInvalid");
    }

    /**
     * Key {@code KubernetesEngineBuilder.NamespaceInvalid}: {@code Namespace
     * is not properly formed, see help for details}.
     * 
     * @return
     *     {@code Namespace is not properly formed, see help for details}
     */
    public static Localizable _KubernetesEngineBuilder_NamespaceInvalid() {
        return new Localizable(holder, "KubernetesEngineBuilder.NamespaceInvalid");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ClusterCredentialIDRequired}:
     * {@code Credential ID required to validate cluster}.
     * 
     * @return
     *     {@code Credential ID required to validate cluster}
     */
    public static String KubernetesEngineBuilder_ClusterCredentialIDRequired() {
        return holder.format("KubernetesEngineBuilder.ClusterCredentialIDRequired");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ClusterCredentialIDRequired}:
     * {@code Credential ID required to validate cluster}.
     * 
     * @return
     *     {@code Credential ID required to validate cluster}
     */
    public static Localizable _KubernetesEngineBuilder_ClusterCredentialIDRequired() {
        return new Localizable(holder, "KubernetesEngineBuilder.ClusterCredentialIDRequired");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ProjectCredentialIDRequired}:
     * {@code Credential ID required to validate Project ID}.
     * 
     * @return
     *     {@code Credential ID required to validate Project ID}
     */
    public static String KubernetesEngineBuilder_ProjectCredentialIDRequired() {
        return holder.format("KubernetesEngineBuilder.ProjectCredentialIDRequired");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ProjectCredentialIDRequired}:
     * {@code Credential ID required to validate Project ID}.
     * 
     * @return
     *     {@code Credential ID required to validate Project ID}
     */
    public static Localizable _KubernetesEngineBuilder_ProjectCredentialIDRequired() {
        return new Localizable(holder, "KubernetesEngineBuilder.ProjectCredentialIDRequired");
    }

    /**
     * Key {@code KubernetesEngineBuilder.NoCredential}: {@code No credential
     * selected}.
     * 
     * @return
     *     {@code No credential selected}
     */
    public static String KubernetesEngineBuilder_NoCredential() {
        return holder.format("KubernetesEngineBuilder.NoCredential");
    }

    /**
     * Key {@code KubernetesEngineBuilder.NoCredential}: {@code No credential
     * selected}.
     * 
     * @return
     *     {@code No credential selected}
     */
    public static Localizable _KubernetesEngineBuilder_NoCredential() {
        return new Localizable(holder, "KubernetesEngineBuilder.NoCredential");
    }

    /**
     * Key {@code KubernetesEngineBuilder.NoClusterInProject}: {@code The
     * selected project has no Kubernetes clusters}.
     * 
     * @return
     *     {@code The selected project has no Kubernetes clusters}
     */
    public static String KubernetesEngineBuilder_NoClusterInProject() {
        return holder.format("KubernetesEngineBuilder.NoClusterInProject");
    }

    /**
     * Key {@code KubernetesEngineBuilder.NoClusterInProject}: {@code The
     * selected project has no Kubernetes clusters}.
     * 
     * @return
     *     {@code The selected project has no Kubernetes clusters}
     */
    public static Localizable _KubernetesEngineBuilder_NoClusterInProject() {
        return new Localizable(holder, "KubernetesEngineBuilder.NoClusterInProject");
    }

    /**
     * Key {@code KubernetesEngineBuilder.VerifyingNObjects}: {@code
     * Verifying {0} objects: }.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Verifying {0} objects: }
     */
    public static String KubernetesEngineBuilder_VerifyingNObjects(Object arg0) {
        return holder.format("KubernetesEngineBuilder.VerifyingNObjects", arg0);
    }

    /**
     * Key {@code KubernetesEngineBuilder.VerifyingNObjects}: {@code
     * Verifying {0} objects: }.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Verifying {0} objects: }
     */
    public static Localizable _KubernetesEngineBuilder_VerifyingNObjects(Object arg0) {
        return new Localizable(holder, "KubernetesEngineBuilder.VerifyingNObjects", arg0);
    }

    /**
     * Key {@code KubernetesEngineBuilder.CredentialAuthFailed}: {@code
     * Credentials failed to authenticate}.
     * 
     * @return
     *     {@code Credentials failed to authenticate}
     */
    public static String KubernetesEngineBuilder_CredentialAuthFailed() {
        return holder.format("KubernetesEngineBuilder.CredentialAuthFailed");
    }

    /**
     * Key {@code KubernetesEngineBuilder.CredentialAuthFailed}: {@code
     * Credentials failed to authenticate}.
     * 
     * @return
     *     {@code Credentials failed to authenticate}
     */
    public static Localizable _KubernetesEngineBuilder_CredentialAuthFailed() {
        return new Localizable(holder, "KubernetesEngineBuilder.CredentialAuthFailed");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ProjectIDNotUnderCredential}:
     * {@code Project ID not managed by provided Service Account
     * Credentials}.
     * 
     * @return
     *     {@code Project ID not managed by provided Service Account Credentials}
     */
    public static String KubernetesEngineBuilder_ProjectIDNotUnderCredential() {
        return holder.format("KubernetesEngineBuilder.ProjectIDNotUnderCredential");
    }

    /**
     * Key {@code KubernetesEngineBuilder.ProjectIDNotUnderCredential}:
     * {@code Project ID not managed by provided Service Account
     * Credentials}.
     * 
     * @return
     *     {@code Project ID not managed by provided Service Account Credentials}
     */
    public static Localizable _KubernetesEngineBuilder_ProjectIDNotUnderCredential() {
        return new Localizable(holder, "KubernetesEngineBuilder.ProjectIDNotUnderCredential");
    }

}
