/*
 * Decompiled with CFR 0.152.
 */
package io.cnaik.service;

import hudson.model.Run;
import io.cnaik.GoogleChatNotification;
import io.cnaik.Messages;
import io.cnaik.service.LogUtil;
import io.cnaik.service.ResponseMessageUtil;
import jenkins.plugins.googlechat.GoogleChatRequest;
import jenkins.plugins.googlechat.GoogleChatService;
import jenkins.plugins.googlechat.HttpClientProvider;
import jenkins.plugins.googlechat.StandardGoogleChatService;
import jenkins.plugins.googlechat.decisions.Context;
import jenkins.plugins.googlechat.decisions.NotificationConditions;

public class CommonUtil {
    private GoogleChatNotification googleChatNotification;
    private Run build;
    private LogUtil logUtil;
    private ResponseMessageUtil responseMessageUtil;
    private final GoogleChatService googleChatService;

    public CommonUtil(GoogleChatNotification googleChatNotification) {
        this.googleChatNotification = googleChatNotification;
        this.build = googleChatNotification.getBuild();
        this.logUtil = googleChatNotification.getLogUtil();
        this.responseMessageUtil = googleChatNotification.getResponseMessageUtil();
        this.googleChatService = new StandardGoogleChatService(new HttpClientProvider());
    }

    public void send() {
        boolean sendNotificationFlag = this.checkWhetherToSend();
        this.logUtil.printLog(Messages.sendGoogleChatNotificationCondition(sendNotificationFlag));
        if (sendNotificationFlag) {
            GoogleChatRequest request = this.createGoogleChatRequest();
            this.logUtil.printLog("%s", Messages.finalFormattedText(request.getBody()));
            String[] urlDetails = this.googleChatNotification.getUrl().split(",");
            boolean success = this.googleChatService.publish(request, urlDetails);
            if (!success) {
                this.logUtil.printLog(Messages.operationMayHaveFailed());
            }
        }
    }

    private GoogleChatRequest createGoogleChatRequest() {
        GoogleChatRequest request = this.googleChatNotification.isCardMessageFormat() ? this.responseMessageUtil.createCardMessage().orElse(GoogleChatRequest.newSimpleRequest().withMessage(Messages.unableToProcessCardMessageJsonConfig()).build()) : this.responseMessageUtil.createTextMessage();
        return request;
    }

    private boolean checkWhetherToSend() {
        if (this.build == null || this.googleChatNotification == null) {
            return false;
        }
        NotificationConditions conditions = NotificationConditions.create(this.googleChatNotification, this.logUtil.getLogger());
        return conditions.noneConditionsUserPreferencesMatches() || conditions.test(new Context(this.build, this.build.getPreviousBuild()));
    }
}

