/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.googlechat.decisions;

import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResult;
import io.cnaik.GoogleChatNotification;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jenkins.plugins.googlechat.decisions.Condition;
import jenkins.plugins.googlechat.decisions.Context;
import jenkins.plugins.googlechat.logging.BuildAwareLogger;

public class OnRegression
implements Condition {
    private final GoogleChatNotification preferences;
    private final BuildAwareLogger log;

    public OnRegression(GoogleChatNotification preferences, BuildAwareLogger log) {
        this.preferences = preferences;
        this.log = log;
    }

    @Override
    public boolean isMetBy(Context context) {
        return context.currentResultOrSuccess().isWorseThan(context.previousResultOrSuccess()) || this.moreTestFailuresThanPrevious(context);
    }

    @Override
    public boolean userPreferenceMatches() {
        return this.preferences.isNotifyRegression();
    }

    @Override
    public BuildAwareLogger log() {
        return this.log;
    }

    private boolean moreTestFailuresThanPrevious(Context context) {
        TestResultAction currentTestResult = context.getCurrentTestResult();
        TestResultAction previousTestResult = context.getPreviousTestResult();
        if (currentTestResult != null && previousTestResult != null) {
            if (currentTestResult.getFailCount() > previousTestResult.getFailCount()) {
                return true;
            }
            return !this.getFailedTestIds(currentTestResult).equals(this.getFailedTestIds(previousTestResult));
        }
        return false;
    }

    private Set<String> getFailedTestIds(TestResultAction testResultAction) {
        HashSet<String> failedTestIds = new HashSet<String>();
        List failedTests = testResultAction.getFailedTests();
        for (TestResult result : failedTests) {
            failedTestIds.add(result.getId());
        }
        return failedTestIds;
    }
}

