/*
 * Decompiled with CFR 0.152.
 */
package io.cnaik.service;

import hudson.FilePath;
import hudson.model.Result;
import hudson.model.Run;
import io.cnaik.GoogleChatNotification;
import io.cnaik.Messages;
import io.cnaik.service.LogUtil;
import java.util.Optional;
import jenkins.plugins.googlechat.GoogleChatRequest;
import jenkins.plugins.googlechat.TokenExpander;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ResponseMessageUtil {
    private static final String JENKINS_BUILD_STATUS_ENV_VAR = "${BUILD_STATUS}";
    private static final String JENKINS_JOB_NAME_ENV_VAR = "${JOB_NAME}";
    private static final String HEX_COLOR_TEAL = "#5DBCD2";
    private static final String HEX_COLOR_RED = "#ff0000";
    private GoogleChatNotification googleChatNotification;
    private FilePath ws;
    private Run build;
    private LogUtil logUtil;
    private TokenExpander tokenExpander;

    public ResponseMessageUtil(GoogleChatNotification googleChatNotification, TokenExpander tokenExpander) {
        this.googleChatNotification = googleChatNotification;
        this.ws = googleChatNotification.getWs();
        this.build = googleChatNotification.getBuild();
        this.logUtil = googleChatNotification.getLogUtil();
        this.tokenExpander = tokenExpander;
    }

    public GoogleChatRequest createTextMessage() {
        String threadKey = this.getThreadKeyForMessages();
        String message = StringEscapeUtils.unescapeJava((String)this.replaceJenkinsKeywords(this.googleChatNotification.getMessage()));
        return GoogleChatRequest.newSimpleRequest().withMessage(message).withThread(threadKey).build();
    }

    public Optional<GoogleChatRequest> createCardMessage() {
        String cardConfigString = this.replaceJenkinsKeywords(this.replaceBuildStatusKeywordWithColorCode(this.googleChatNotification.getMessage()));
        return this.toJson(cardConfigString).map(cardConfig -> {
            GoogleChatRequest.GoogleChatRequestCardBuilder requestBuilder = GoogleChatRequest.newCardRequest().withCardConfig((JSONObject)cardConfig);
            if (cardConfig.has("thread")) {
                this.logUtil.printLog(Messages.providedJsonMessageContainsThreadKey());
            } else {
                String threadKey = this.getThreadKeyForMessages();
                requestBuilder.withThread(threadKey);
            }
            return requestBuilder.build();
        });
    }

    private Optional<JSONObject> toJson(String jsonMessage) {
        try {
            this.logUtil.printDebug("Parsing JSON config:\n%s", jsonMessage);
            return Optional.of(new JSONObject(jsonMessage));
        }
        catch (JSONException exception) {
            this.logUtil.printLog(Messages.exceptionProcessingJsonMessage(exception.getMessage()));
            return Optional.empty();
        }
    }

    private String getThreadKeyForMessages() {
        String threadKey = null;
        if (this.googleChatNotification.isSameThreadNotification()) {
            threadKey = (String)StringUtils.defaultIfBlank((CharSequence)this.replaceJenkinsKeywords(this.googleChatNotification.getThreadKey()), (CharSequence)this.getJobName());
        }
        this.logUtil.printLog(Messages.willSendMessageToThread(threadKey));
        return threadKey;
    }

    private String getJobName() {
        return this.tokenExpander.expand(JENKINS_JOB_NAME_ENV_VAR, this.build, this.ws);
    }

    private String replaceJenkinsKeywords(String inputString) {
        return this.tokenExpander.expand(inputString, this.build, this.ws);
    }

    private String replaceBuildStatusKeywordWithColorCode(String inputString) {
        String outputString = inputString;
        if (StringUtils.isEmpty((CharSequence)outputString)) {
            return outputString;
        }
        if (outputString.contains(JENKINS_BUILD_STATUS_ENV_VAR)) {
            Result buildStatus = this.build.getResult();
            outputString = buildStatus == Result.FAILURE ? outputString.replace(JENKINS_BUILD_STATUS_ENV_VAR, "<font color=\\\"#ff0000\\\">${BUILD_STATUS}</font>") : outputString.replace(JENKINS_BUILD_STATUS_ENV_VAR, "<font color=\\\"#5DBCD2\\\">${BUILD_STATUS}</font>");
        } else {
            return outputString;
        }
        return outputString;
    }
}

