/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.googlechat.logging;

import hudson.model.TaskListener;
import java.util.logging.Logger;
import jenkins.plugins.googlechat.logging.BuildAwareLogger;

public class GoogleChatNotificationsLogger
implements BuildAwareLogger {
    private static final String PLUGIN_KEY = String.format("[%s]", "Google Chat Notification");
    private final Logger system;
    private final TaskListener user;
    private final boolean suppressInfoLoggers;

    public GoogleChatNotificationsLogger(Logger system, TaskListener listener, boolean suppressInfoLoggers) {
        this.system = system;
        this.user = listener;
        this.suppressInfoLoggers = suppressInfoLoggers;
    }

    @Override
    public void debug(String key, String message, Object ... args) {
        this.system.fine(() -> String.join((CharSequence)" ", key, String.format(message, args)));
    }

    @Override
    public void info(String key, String message, Object ... args) {
        String formattedMessage = String.format(message, args);
        this.system.info(() -> String.join((CharSequence)" ", key, formattedMessage));
        if (!this.suppressInfoLoggers) {
            this.user.getLogger().println(String.join((CharSequence)" ", PLUGIN_KEY, formattedMessage));
        }
    }

    @Override
    public TaskListener getTaskListener() {
        return this.user;
    }
}

