/*
 * Decompiled with CFR 0.152.
 */
package io.cnaik;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.cnaik.Messages;
import io.cnaik.service.CommonUtil;
import io.cnaik.service.LogUtil;
import io.cnaik.service.ResponseMessageUtil;
import java.util.Locale;
import jenkins.plugins.googlechat.JenkinsTokenExpander;
import jenkins.plugins.googlechat.MessageFormat;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.json.JSONException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class GoogleChatNotification
extends Notifier
implements SimpleBuildStep {
    private String url;
    private String message;
    private MessageFormat messageFormat;
    private boolean sameThreadNotification;
    private String threadKey;
    private boolean notifyAborted;
    private boolean notifyFailure;
    private boolean notifySingleFailure;
    private boolean notifyRepeatedFailure;
    private boolean notifyRegression;
    private boolean notifyNotBuilt;
    private boolean notifySuccess;
    private boolean notifyUnstable;
    private boolean notifyBackToNormal;
    private boolean suppressInfoLoggers;
    private TaskListener taskListener;
    private FilePath ws;
    private Run build;
    private LogUtil logUtil;
    private ResponseMessageUtil responseMessageUtil;

    @DataBoundConstructor
    public GoogleChatNotification(String url, String message) {
        this.url = url;
        this.message = message;
    }

    @DataBoundSetter
    public void setMessageFormat(Object messageFormat) {
        this.messageFormat = messageFormat != null ? (messageFormat instanceof String ? MessageFormat.valueOf(((String)messageFormat).toUpperCase(Locale.ROOT)) : (messageFormat instanceof MessageFormat ? (MessageFormat)((Object)messageFormat) : null)) : null;
    }

    @DataBoundSetter
    public void setSameThreadNotification(boolean sameThreadNotification) {
        this.sameThreadNotification = sameThreadNotification;
    }

    @DataBoundSetter
    public void setThreadKey(String threadKey) {
        this.threadKey = threadKey;
    }

    @DataBoundSetter
    public void setNotifyAborted(boolean notifyAborted) {
        this.notifyAborted = notifyAborted;
    }

    @DataBoundSetter
    public void setNotifyFailure(boolean notifyFailure) {
        this.notifyFailure = notifyFailure;
    }

    @DataBoundSetter
    public void setNotifySingleFailure(boolean notifySingleFailure) {
        this.notifySingleFailure = notifySingleFailure;
    }

    @DataBoundSetter
    public void setNotifyRepeatedFailure(boolean notifyRepeatedFailure) {
        this.notifyRepeatedFailure = notifyRepeatedFailure;
    }

    @DataBoundSetter
    public void setNotifyRegression(boolean notifyRegression) {
        this.notifyRegression = notifyRegression;
    }

    @DataBoundSetter
    public void setNotifyNotBuilt(boolean notifyNotBuilt) {
        this.notifyNotBuilt = notifyNotBuilt;
    }

    @DataBoundSetter
    public void setNotifySuccess(boolean notifySuccess) {
        this.notifySuccess = notifySuccess;
    }

    @DataBoundSetter
    public void setNotifyUnstable(boolean notifyUnstable) {
        this.notifyUnstable = notifyUnstable;
    }

    @DataBoundSetter
    public void setNotifyBackToNormal(boolean notifyBackToNormal) {
        this.notifyBackToNormal = notifyBackToNormal;
    }

    @DataBoundSetter
    public void setSuppressInfoLoggers(boolean suppressInfoLoggers) {
        this.suppressInfoLoggers = suppressInfoLoggers;
    }

    public String getUrl() {
        if (StringUtils.isBlank((CharSequence)this.url)) {
            return this.getDescriptor().getUrl();
        }
        return this.url;
    }

    public String getMessage() {
        if (StringUtils.isBlank((CharSequence)this.message)) {
            return this.getDescriptor().getMessage();
        }
        return this.message;
    }

    public MessageFormat getMessageFormat() {
        if (this.messageFormat == null) {
            return this.getDescriptor().getMessageFormat();
        }
        return this.messageFormat;
    }

    public boolean isSimpleMessageFormat() {
        return MessageFormat.SIMPLE == this.messageFormat;
    }

    public boolean isCardMessageFormat() {
        return MessageFormat.CARD == this.messageFormat;
    }

    public String getThreadKey() {
        if (StringUtils.isBlank((CharSequence)this.threadKey)) {
            return this.getDescriptor().getThreadKey();
        }
        return this.threadKey;
    }

    public boolean isSameThreadNotification() {
        return this.sameThreadNotification;
    }

    public boolean isNotifyAborted() {
        return this.notifyAborted;
    }

    public boolean isNotifyFailure() {
        return this.notifyFailure;
    }

    public boolean isNotifySingleFailure() {
        return this.notifySingleFailure;
    }

    public boolean isNotifyRepeatedFailure() {
        return this.notifyRepeatedFailure;
    }

    public boolean isNotifyRegression() {
        return this.notifyRegression;
    }

    public boolean isNotifyNotBuilt() {
        return this.notifyNotBuilt;
    }

    public boolean isNotifySuccess() {
        return this.notifySuccess;
    }

    public boolean isNotifyUnstable() {
        return this.notifyUnstable;
    }

    public boolean isNotifyBackToNormal() {
        return this.notifyBackToNormal;
    }

    public boolean isSuppressInfoLoggers() {
        return this.suppressInfoLoggers;
    }

    public TaskListener getTaskListener() {
        return this.taskListener;
    }

    public void setTaskListener(TaskListener taskListener) {
        this.taskListener = taskListener;
    }

    public FilePath getWs() {
        return this.ws;
    }

    public void setWs(FilePath ws) {
        this.ws = ws;
    }

    public Run getBuild() {
        return this.build;
    }

    public void setBuild(Run build) {
        this.build = build;
    }

    public LogUtil getLogUtil() {
        return this.logUtil;
    }

    public void setLogUtil(LogUtil logUtil) {
        this.logUtil = logUtil;
    }

    public ResponseMessageUtil getResponseMessageUtil() {
        return this.responseMessageUtil;
    }

    public void setResponseMessageUtil(ResponseMessageUtil responseMessageUtil) {
        this.responseMessageUtil = responseMessageUtil;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        this.setBuild((Run)build);
        this.setWs(null);
        this.setTaskListener((TaskListener)listener);
        this.performAction();
        return true;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) {
        this.setBuild(run);
        this.setWs(workspace);
        this.setTaskListener(listener);
        this.performAction();
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private void performAction() {
        LogUtil logUtil = new LogUtil(this);
        this.setLogUtil(logUtil);
        JenkinsTokenExpander tokenExpander = new JenkinsTokenExpander(this.taskListener);
        ResponseMessageUtil responseMessageUtil = new ResponseMessageUtil(this, tokenExpander);
        this.setResponseMessageUtil(responseMessageUtil);
        CommonUtil commonUtil = new CommonUtil(this);
        commonUtil.send();
    }

    public String toString() {
        return "GoogleChatNotification{url='" + this.url + "', message='" + this.message + "', messageFormat=" + String.valueOf((Object)this.messageFormat) + ", sameThreadNotification='" + this.sameThreadNotification + "', threadKey='" + this.threadKey + "', notifyAborted=" + this.notifyAborted + ", notifyFailure=" + this.notifyFailure + ", notifyNotBuilt=" + this.notifyNotBuilt + ", notifySuccess=" + this.notifySuccess + ", notifyUnstable=" + this.notifyUnstable + ", notifyBackToNormal=" + this.notifyBackToNormal + ", suppressInfoLoggers=" + this.suppressInfoLoggers + "}";
    }

    @Symbol(value={"googlechatnotification"})
    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Publisher> {
        public static final String PLUGIN_DISPLAY_NAME = "Google Chat Notification";
        public static final MessageFormat defaultMessageFormat = MessageFormat.SIMPLE;
        private String url;
        private String message;
        private MessageFormat messageFormat;
        private boolean sameThreadNotification;
        private String threadKey;
        private boolean notifyAborted;
        private boolean notifyFailure;
        private boolean notifyNotBuilt;
        private boolean notifySuccess;
        private boolean notifyUnstable;
        private boolean notifyBackToNormal;
        private boolean suppressInfoLoggers;

        @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="The Descriptor#load documentation states that \"The constructor of the derived class must call this method\".")
        public Descriptor() {
            this.load();
        }

        public FormValidation doCheckUrl(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.googleChatNotificationUrlNotDefined());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMessage(@QueryParameter String value, @QueryParameter MessageFormat messageFormat) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.messageNotDefined());
            }
            if (MessageFormat.CARD.equals((Object)messageFormat) && !this.isJSONValid(value)) {
                return FormValidation.error((String)Messages.messageNotValidJson());
            }
            return FormValidation.ok();
        }

        private boolean isJSONValid(String test) {
            try {
                new org.json.JSONObject(test);
            }
            catch (JSONException ex) {
                return false;
            }
            return true;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return PLUGIN_DISPLAY_NAME;
        }

        public ListBoxModel doFillMessageFormatItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(MessageFormat.SIMPLE.getDisplayName(), MessageFormat.SIMPLE.name());
            items.add(MessageFormat.CARD.getDisplayName(), MessageFormat.CARD.name());
            return items;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.url = formData.getString("url");
            this.message = formData.getString("message");
            this.messageFormat = MessageFormat.valueOf(formData.getString("messageFormat"));
            this.sameThreadNotification = formData.getBoolean("sameThreadNotification");
            this.threadKey = formData.getString("threadKey");
            this.notifyAborted = formData.getBoolean("notifyAborted");
            this.notifyFailure = formData.getBoolean("notifyFailure");
            this.notifyNotBuilt = formData.getBoolean("notifyNotBuilt");
            this.notifySuccess = formData.getBoolean("notifySuccess");
            this.notifyUnstable = formData.getBoolean("notifyUnstable");
            this.notifyBackToNormal = formData.getBoolean("notifyBackToNormal");
            this.suppressInfoLoggers = formData.getBoolean("suppressInfoLoggers");
            this.save();
            return super.configure(req, formData);
        }

        public String getUrl() {
            return this.url;
        }

        public String getMessage() {
            return this.message;
        }

        public MessageFormat getMessageFormat() {
            return this.messageFormat != null ? this.messageFormat : defaultMessageFormat;
        }

        public boolean isSameThreadNotification() {
            return this.sameThreadNotification;
        }

        public String getThreadKey() {
            return this.threadKey;
        }

        public boolean isNotifyAborted() {
            return this.notifyAborted;
        }

        public boolean isNotifyFailure() {
            return this.notifyFailure;
        }

        public boolean isNotifyNotBuilt() {
            return this.notifyNotBuilt;
        }

        public boolean isNotifySuccess() {
            return this.notifySuccess;
        }

        public boolean isNotifyUnstable() {
            return this.notifyUnstable;
        }

        public boolean isNotifyBackToNormal() {
            return this.notifyBackToNormal;
        }

        public boolean isSuppressInfoLoggers() {
            return this.suppressInfoLoggers;
        }
    }
}

