// CHECKSTYLE:OFF

package io.cnaik;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code willSendMessageToThread}: {@code Will send message to the
     * thread: {0}. If it doesn't exist yet or is 'null', it will be
     * created.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Will send message to the thread: {0}. If it doesn't exist yet
     *     or is 'null', it will be created.}
     */
    public static String willSendMessageToThread(Object arg0) {
        return holder.format("willSendMessageToThread", arg0);
    }

    /**
     * Key {@code willSendMessageToThread}: {@code Will send message to the
     * thread: {0}. If it doesn't exist yet or is 'null', it will be
     * created.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Will send message to the thread: {0}. If it doesn't exist yet
     *     or is 'null', it will be created.}
     */
    public static Localizable _willSendMessageToThread(Object arg0) {
        return new Localizable(holder, "willSendMessageToThread", arg0);
    }

    /**
     * Key {@code finalFormattedText}: {@code Final formatted text:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Final formatted text:
     *     {0}}
     */
    public static String finalFormattedText(Object arg0) {
        return holder.format("finalFormattedText", arg0);
    }

    /**
     * Key {@code finalFormattedText}: {@code Final formatted text:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Final formatted text:
     *     {0}}
     */
    public static Localizable _finalFormattedText(Object arg0) {
        return new Localizable(holder, "finalFormattedText", arg0);
    }

    /**
     * Key {@code providedJsonMessageContainsThreadKey}: {@code "WARN: Since
     * the provided JSON message already contains a 'thread' key, the plugin
     * parameters 'sameThreadNotification' and 'threadKey' will be ignored"}.
     * 
     * @return
     *     {@code "WARN: Since the provided JSON message already contains a
     *     'thread' key, the plugin parameters 'sameThreadNotification' and
     *     'threadKey' will be ignored"}
     */
    public static String providedJsonMessageContainsThreadKey() {
        return holder.format("providedJsonMessageContainsThreadKey");
    }

    /**
     * Key {@code providedJsonMessageContainsThreadKey}: {@code "WARN: Since
     * the provided JSON message already contains a 'thread' key, the plugin
     * parameters 'sameThreadNotification' and 'threadKey' will be ignored"}.
     * 
     * @return
     *     {@code "WARN: Since the provided JSON message already contains a
     *     'thread' key, the plugin parameters 'sameThreadNotification' and
     *     'threadKey' will be ignored"}
     */
    public static Localizable _providedJsonMessageContainsThreadKey() {
        return new Localizable(holder, "providedJsonMessageContainsThreadKey");
    }

    /**
     * Key {@code unableToProcessCardMessageJsonConfig}: {@code ERROR: Unable
     * to process card message JSON. Please check your configuration.}.
     * 
     * @return
     *     {@code ERROR: Unable to process card message JSON. Please check your
     *     configuration.}
     */
    public static String unableToProcessCardMessageJsonConfig() {
        return holder.format("unableToProcessCardMessageJsonConfig");
    }

    /**
     * Key {@code unableToProcessCardMessageJsonConfig}: {@code ERROR: Unable
     * to process card message JSON. Please check your configuration.}.
     * 
     * @return
     *     {@code ERROR: Unable to process card message JSON. Please check your
     *     configuration.}
     */
    public static Localizable _unableToProcessCardMessageJsonConfig() {
        return new Localizable(holder, "unableToProcessCardMessageJsonConfig");
    }

    /**
     * Key {@code operationMayHaveFailed}: {@code Operation may have failed.
     * Please check system log for details.}.
     * 
     * @return
     *     {@code Operation may have failed. Please check system log for
     *     details.}
     */
    public static String operationMayHaveFailed() {
        return holder.format("operationMayHaveFailed");
    }

    /**
     * Key {@code operationMayHaveFailed}: {@code Operation may have failed.
     * Please check system log for details.}.
     * 
     * @return
     *     {@code Operation may have failed. Please check system log for
     *     details.}
     */
    public static Localizable _operationMayHaveFailed() {
        return new Localizable(holder, "operationMayHaveFailed");
    }

    /**
     * Key {@code sendGoogleChatNotificationCondition}: {@code Send Google
     * Chat Notification condition is: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Send Google Chat Notification condition is: {0}}
     */
    public static String sendGoogleChatNotificationCondition(Object arg0) {
        return holder.format("sendGoogleChatNotificationCondition", arg0);
    }

    /**
     * Key {@code sendGoogleChatNotificationCondition}: {@code Send Google
     * Chat Notification condition is: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Send Google Chat Notification condition is: {0}}
     */
    public static Localizable _sendGoogleChatNotificationCondition(Object arg0) {
        return new Localizable(holder, "sendGoogleChatNotificationCondition", arg0);
    }

    /**
     * Key {@code googleChatPostMayHaveFailed}: {@code Google Chat post may
     * have failed. Response: {0}, Response Code: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Google Chat post may have failed. Response: {0}, Response Code:
     *     {1}}
     */
    public static String googleChatPostMayHaveFailed(Object arg0, Object arg1) {
        return holder.format("googleChatPostMayHaveFailed", arg0, arg1);
    }

    /**
     * Key {@code googleChatPostMayHaveFailed}: {@code Google Chat post may
     * have failed. Response: {0}, Response Code: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Google Chat post may have failed. Response: {0}, Response Code:
     *     {1}}
     */
    public static Localizable _googleChatPostMayHaveFailed(Object arg0, Object arg1) {
        return new Localizable(holder, "googleChatPostMayHaveFailed", arg0, arg1);
    }

    /**
     * Key {@code messageNotValidJson}: {@code Please provide a valid JSON}.
     * 
     * @return
     *     {@code Please provide a valid JSON}
     */
    public static String messageNotValidJson() {
        return holder.format("messageNotValidJson");
    }

    /**
     * Key {@code messageNotValidJson}: {@code Please provide a valid JSON}.
     * 
     * @return
     *     {@code Please provide a valid JSON}
     */
    public static Localizable _messageNotValidJson() {
        return new Localizable(holder, "messageNotValidJson");
    }

    /**
     * Key {@code messageNotDefined}: {@code Please add message}.
     * 
     * @return
     *     {@code Please add message}
     */
    public static String messageNotDefined() {
        return holder.format("messageNotDefined");
    }

    /**
     * Key {@code messageNotDefined}: {@code Please add message}.
     * 
     * @return
     *     {@code Please add message}
     */
    public static Localizable _messageNotDefined() {
        return new Localizable(holder, "messageNotDefined");
    }

    /**
     * Key {@code exceptionPostingGoogleChatMessage}: {@code Exception while
     * posting Google Chat message: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception while posting Google Chat message: {0}}
     */
    public static String exceptionPostingGoogleChatMessage(Object arg0) {
        return holder.format("exceptionPostingGoogleChatMessage", arg0);
    }

    /**
     * Key {@code exceptionPostingGoogleChatMessage}: {@code Exception while
     * posting Google Chat message: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception while posting Google Chat message: {0}}
     */
    public static Localizable _exceptionPostingGoogleChatMessage(Object arg0) {
        return new Localizable(holder, "exceptionPostingGoogleChatMessage", arg0);
    }

    /**
     * Key {@code failedToProcessTokenMacros}: {@code Failed to process token
     * macros.}.
     * 
     * @return
     *     {@code Failed to process token macros.}
     */
    public static String failedToProcessTokenMacros() {
        return holder.format("failedToProcessTokenMacros");
    }

    /**
     * Key {@code failedToProcessTokenMacros}: {@code Failed to process token
     * macros.}.
     * 
     * @return
     *     {@code Failed to process token macros.}
     */
    public static Localizable _failedToProcessTokenMacros() {
        return new Localizable(holder, "failedToProcessTokenMacros");
    }

    /**
     * Key {@code invalidGoogleChatNotificationUrl}: {@code Invalid Google
     * Chat Notification URL found: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid Google Chat Notification URL found: {0}}
     */
    public static String invalidGoogleChatNotificationUrl(Object arg0) {
        return holder.format("invalidGoogleChatNotificationUrl", arg0);
    }

    /**
     * Key {@code invalidGoogleChatNotificationUrl}: {@code Invalid Google
     * Chat Notification URL found: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid Google Chat Notification URL found: {0}}
     */
    public static Localizable _invalidGoogleChatNotificationUrl(Object arg0) {
        return new Localizable(holder, "invalidGoogleChatNotificationUrl", arg0);
    }

    /**
     * Key {@code exceptionProcessingJsonMessage}: {@code Exception while
     * trying to process JSON message: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception while trying to process JSON message: {0}}
     */
    public static String exceptionProcessingJsonMessage(Object arg0) {
        return holder.format("exceptionProcessingJsonMessage", arg0);
    }

    /**
     * Key {@code exceptionProcessingJsonMessage}: {@code Exception while
     * trying to process JSON message: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception while trying to process JSON message: {0}}
     */
    public static Localizable _exceptionProcessingJsonMessage(Object arg0) {
        return new Localizable(holder, "exceptionProcessingJsonMessage", arg0);
    }

    /**
     * Key {@code googleChatNotificationUrlNotDefined}: {@code Please add at
     * least one google chat notification URL}.
     * 
     * @return
     *     {@code Please add at least one google chat notification URL}
     */
    public static String googleChatNotificationUrlNotDefined() {
        return holder.format("googleChatNotificationUrlNotDefined");
    }

    /**
     * Key {@code googleChatNotificationUrlNotDefined}: {@code Please add at
     * least one google chat notification URL}.
     * 
     * @return
     *     {@code Please add at least one google chat notification URL}
     */
    public static Localizable _googleChatNotificationUrlNotDefined() {
        return new Localizable(holder, "googleChatNotificationUrlNotDefined");
    }

}
