/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.googlechat;

import io.cnaik.Messages;
import io.cnaik.model.google.MessageReplyOption;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.googlechat.CredentialsObtainer;
import jenkins.plugins.googlechat.GoogleChatRequest;
import jenkins.plugins.googlechat.GoogleChatService;
import jenkins.plugins.googlechat.HttpClientProvider;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class StandardGoogleChatService
implements GoogleChatService {
    private static final Logger logger = Logger.getLogger(StandardGoogleChatService.class.getName());
    private static final long TIMEOUT = 15000L;
    private final HttpClientProvider httpClientProvider;
    private String responseString;

    public StandardGoogleChatService(HttpClientProvider httpClientProvider) {
        this.httpClientProvider = httpClientProvider;
    }

    @Override
    public String getResponseString() {
        return this.responseString;
    }

    @Override
    public boolean publish(GoogleChatRequest request, String ... notificationUrls) {
        boolean success = false;
        for (String urlDetail : notificationUrls) {
            success = this.call(urlDetail, request);
            if (!success && StringUtils.isNotEmpty((CharSequence)urlDetail) && urlDetail.trim().startsWith("id:")) {
                String[] url = urlDetail.trim().split("id:");
                CredentialsObtainer credentialsObtainer = this.getCredentialsObtainer();
                StringCredentials stringCredentials = credentialsObtainer.lookupCredentials(url[1]);
                if (stringCredentials != null) {
                    success = this.call(stringCredentials.getSecret().getPlainText(), request);
                }
            }
            if (success) continue;
            logger.log(Level.WARNING, Messages.invalidGoogleChatNotificationUrl(urlDetail));
        }
        return success;
    }

    protected CredentialsObtainer getCredentialsObtainer() {
        return new CredentialsObtainer();
    }

    private boolean call(String urlDetail, GoogleChatRequest request) {
        boolean success = true;
        if (this.checkIfValidURL((String)urlDetail)) {
            try {
                if (request.getThread() != null) {
                    urlDetail = (String)urlDetail + "&messageReplyOption=" + String.valueOf((Object)MessageReplyOption.REPLY_MESSAGE_FALLBACK_TO_NEW_THREAD);
                    logger.log(Level.INFO, Messages.willSendMessageToThread(request.getThread()));
                }
                HttpClient client = this.getHttpClient();
                HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create((String)urlDetail)).POST(HttpRequest.BodyPublishers.ofString(request.getBody().toString())).timeout(Duration.ofSeconds(15000L)).build();
                HttpResponse<String> response = client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
                this.responseString = response.body();
                if (response.statusCode() != 200) {
                    logger.log(Level.WARNING, Messages.googleChatPostMayHaveFailed(this.responseString, response.statusCode()));
                    success = false;
                }
            }
            catch (IOException | InterruptedException e) {
                logger.log(Level.WARNING, Messages.exceptionPostingGoogleChatMessage(e.getMessage()));
                success = false;
            }
        } else {
            success = false;
        }
        return success;
    }

    protected HttpClient getHttpClient() {
        return this.httpClientProvider.getNewClient();
    }

    private boolean checkIfValidURL(String url) {
        return StringUtils.isNotEmpty((CharSequence)url) && (url.trim().contains("https") || url.trim().contains("http")) && url.trim().contains("?");
    }
}

