/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.googlechat.decisions;

import io.cnaik.GoogleChatNotification;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import jenkins.plugins.googlechat.decisions.Condition;
import jenkins.plugins.googlechat.decisions.Context;
import jenkins.plugins.googlechat.decisions.OnAborted;
import jenkins.plugins.googlechat.decisions.OnBackToNormal;
import jenkins.plugins.googlechat.decisions.OnEveryFailure;
import jenkins.plugins.googlechat.decisions.OnNotBuilt;
import jenkins.plugins.googlechat.decisions.OnRegression;
import jenkins.plugins.googlechat.decisions.OnRepeatedFailure;
import jenkins.plugins.googlechat.decisions.OnSingleFailure;
import jenkins.plugins.googlechat.decisions.OnSuccess;
import jenkins.plugins.googlechat.decisions.OnUnstable;
import jenkins.plugins.googlechat.logging.BuildAwareLogger;

public class NotificationConditions
implements Predicate<Context> {
    private final List<Condition> conditions;

    public NotificationConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public static NotificationConditions create(GoogleChatNotification preferences, BuildAwareLogger log) {
        return new NotificationConditions(Arrays.asList(new OnAborted(preferences, log), new OnSingleFailure(preferences, log), new OnRepeatedFailure(preferences, log), new OnEveryFailure(preferences, log), new OnRegression(preferences, log), new OnNotBuilt(preferences, log), new OnBackToNormal(preferences, log), new OnSuccess(preferences, log), new OnUnstable(preferences, log)));
    }

    public boolean noneConditionsUserPreferencesMatches() {
        return this.conditions.stream().noneMatch(p -> p.userPreferenceMatches());
    }

    @Override
    public boolean test(Context context) {
        return this.conditions.stream().anyMatch(p -> p.test(context));
    }
}

