/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.googlechat.decisions;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.TestResultAction;
import jenkins.plugins.googlechat.logging.BuildKey;

public class Context {
    private final Run<?, ?> current;
    private final Run<?, ?> previous;

    public Context(Run<?, ?> current, Run<?, ?> previous) {
        this.current = current;
        this.previous = previous;
    }

    public String currentKey() {
        return BuildKey.format(this.current);
    }

    public Result previousResultOrSuccess() {
        if (this.previous == null || this.previous.getResult() == null) {
            return Result.SUCCESS;
        }
        return this.previous.getResult();
    }

    @Nullable
    public Result currentResult() {
        if (this.current == null) {
            return null;
        }
        return this.current.getResult();
    }

    public Result currentResultOrSuccess() {
        if (this.current == null || this.current.getResult() == null) {
            return Result.SUCCESS;
        }
        return this.current.getResult();
    }

    @Nullable
    private TestResultAction getTestResult(Run<?, ?> build) {
        if (build == null) {
            return null;
        }
        return (TestResultAction)build.getAction(TestResultAction.class);
    }

    @Nullable
    public TestResultAction getPreviousTestResult() {
        return this.getTestResult(this.previous);
    }

    @Nullable
    public TestResultAction getCurrentTestResult() {
        return this.getTestResult(this.current);
    }
}

