/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.googlechat;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.StandardCharsets;
import org.json.JSONObject;
import org.springframework.web.util.UriUtils;

public class GoogleChatRequest {
    private static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    private final String message;
    private final String thread;
    private final JSONObject cardConfig;

    private GoogleChatRequest(@Nullable String message, @Nullable String thread, @Nullable JSONObject cardConfig) {
        if (message != null && cardConfig != null) {
            throw new IllegalArgumentException("Invalid arguments: can't create a request with both a text message and a card message");
        }
        if (message == null && cardConfig == null) {
            throw new IllegalArgumentException("Invalid arguments: must create a request with either a text message or a card message");
        }
        this.message = message;
        this.thread = thread;
        this.cardConfig = cardConfig;
    }

    public static GoogleChatRequestSimpleBuilder newSimpleRequest() {
        return new GoogleChatRequestSimpleBuilder();
    }

    public static GoogleChatRequestCardBuilder newCardRequest() {
        return new GoogleChatRequestCardBuilder();
    }

    public JSONObject getBody() {
        JSONObject body;
        JSONObject jSONObject = body = this.cardConfig != null ? this.cardConfig : new JSONObject();
        if (this.message != null) {
            body.put("text", (Object)this.message);
        }
        if (this.thread != null) {
            body.put("thread", (Object)this.createThreadJson(this.thread));
        }
        return body;
    }

    private JSONObject createThreadJson(String threadKey) {
        JSONObject thread = new JSONObject();
        thread.put("threadKey", (Object)UriUtils.encodePath((String)threadKey, (String)DEFAULT_ENCODING));
        return thread;
    }

    public String getThread() {
        return this.thread;
    }

    public static class GoogleChatRequestSimpleBuilder {
        private String message;
        private String thread;

        private GoogleChatRequestSimpleBuilder() {
        }

        public GoogleChatRequestSimpleBuilder withMessage(String message) {
            this.message = message;
            return this;
        }

        public GoogleChatRequestSimpleBuilder withThread(String thread) {
            this.thread = thread;
            return this;
        }

        public GoogleChatRequest build() {
            return new GoogleChatRequest(this.message, this.thread, null);
        }
    }

    public static class GoogleChatRequestCardBuilder {
        private JSONObject cardConfig;
        private String thread;

        private GoogleChatRequestCardBuilder() {
        }

        public GoogleChatRequestCardBuilder withCardConfig(JSONObject cardConfig) {
            this.cardConfig = cardConfig;
            this.thread = this.getThreadKey(cardConfig);
            return this;
        }

        private String getThreadKey(JSONObject cardConfig) {
            if (cardConfig.has("thread")) {
                JSONObject thread = cardConfig.getJSONObject("thread");
                return thread.has("threadKey") ? thread.getString("threadKey") : null;
            }
            return null;
        }

        public GoogleChatRequestCardBuilder withThread(String thread) {
            this.thread = thread;
            return this;
        }

        public GoogleChatRequest build() {
            return new GoogleChatRequest(null, this.thread, this.cardConfig);
        }
    }
}

