/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.xstream.migration;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.plugins.global_build_stats.model.JobBuildResultSharder;
import hudson.plugins.global_build_stats.model.ModelIdGenerator;
import hudson.plugins.global_build_stats.rententionstrategies.RetentionStrategy;
import hudson.plugins.global_build_stats.xstream.migration.GlobalBuildStatsDataMigrator;
import hudson.plugins.global_build_stats.xstream.migration.GlobalBuildStatsPOJO;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMigrator<TFROM extends GlobalBuildStatsPOJO, TTO extends GlobalBuildStatsPOJO>
implements GlobalBuildStatsDataMigrator<TFROM, TTO> {
    @Override
    public TTO migrate(TFROM pojo) {
        TTO migratedPojo = this.createMigratedPojo();
        migratedPojo.setBuildStatConfigs(this.migrateBuildStatConfigs(pojo.getBuildStatConfigs()));
        migratedPojo.setJobBuildResults(this.migrateJobBuildResults(pojo.getJobBuildResults()));
        migratedPojo.setRetentionStrategies(this.migrateRetentionStrategies(pojo.getRetentionStrategies()));
        return migratedPojo;
    }

    @Override
    public TTO readGlobalBuildStatsPOJO(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TTO pojo = this.createMigratedPojo();
        List<JobBuildResult> jobBuildResults = JobBuildResultSharder.load();
        reader.moveDown();
        ArrayList<BuildStatConfiguration> buildStatConfigs = new ArrayList<BuildStatConfiguration>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            BuildStatConfiguration bsc = (BuildStatConfiguration)context.convertAnother(pojo, BuildStatConfiguration.class);
            buildStatConfigs.add(bsc);
            if (this.registerBuildStatConfigId()) {
                ModelIdGenerator.INSTANCE.registerIdForClass(BuildStatConfiguration.class, bsc.getId());
            }
            reader.moveUp();
        }
        reader.moveUp();
        reader.moveDown();
        List retentionStrategiesFakedInstances = (List)context.convertAnother(pojo, List.class);
        ArrayList<RetentionStrategy> retentionStrategies = new ArrayList<RetentionStrategy>(retentionStrategiesFakedInstances.size());
        for (RetentionStrategy fakeStrategy : retentionStrategiesFakedInstances) {
            RetentionStrategy rs = RetentionStrategy.valueOf(fakeStrategy.getId());
            rs.from(fakeStrategy);
            retentionStrategies.add(rs);
        }
        reader.moveUp();
        pojo.setJobBuildResults(jobBuildResults);
        pojo.setBuildStatConfigs(buildStatConfigs);
        pojo.setRetentionStrategies(retentionStrategies);
        return pojo;
    }

    protected List<BuildStatConfiguration> migrateBuildStatConfigs(List<BuildStatConfiguration> buildStatConfigs) {
        return new ArrayList<BuildStatConfiguration>(buildStatConfigs);
    }

    protected List<JobBuildResult> migrateJobBuildResults(List<JobBuildResult> jobBuildResults) {
        return new ArrayList<JobBuildResult>(jobBuildResults);
    }

    protected List<RetentionStrategy> migrateRetentionStrategies(List<RetentionStrategy> retentionStrategies) {
        return new ArrayList<RetentionStrategy>(retentionStrategies);
    }

    protected boolean registerBuildStatConfigId() {
        return true;
    }

    protected static Run<?, ?> retrieveBuildFromJobBuildResult(JobBuildResult jbr) {
        Job job = (Job)Hudson.getInstance().getItemByFullName(jbr.getJobName());
        if (job != null) {
            return job.getBuildByNumber(jbr.getBuildNumber());
        }
        return null;
    }

    protected abstract TTO createMigratedPojo();
}

