/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.plugins.global_build_stats.GlobalBuildStatsPlugin;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.xstream.migration.GlobalBuildStatsDataMigrator;
import hudson.plugins.global_build_stats.xstream.migration.GlobalBuildStatsPOJO;
import hudson.plugins.global_build_stats.xstream.migration.v0.InitialMigrator;
import hudson.plugins.global_build_stats.xstream.migration.v1.V0ToV1Migrator;
import hudson.plugins.global_build_stats.xstream.migration.v2.V1ToV2Migrator;
import hudson.plugins.global_build_stats.xstream.migration.v3.V2ToV3Migrator;
import hudson.plugins.global_build_stats.xstream.migration.v4.V3ToV4Migrator;
import hudson.plugins.global_build_stats.xstream.migration.v5.V4ToV5Migrator;
import hudson.plugins.global_build_stats.xstream.migration.v6.V5ToV6Migrator;
import hudson.plugins.global_build_stats.xstream.migration.v7.V6ToV7Migrator;
import hudson.plugins.global_build_stats.xstream.migration.v8.V7ToV8Migrator;
import hudson.plugins.global_build_stats.xstream.migration.v9.V8ToV9Migrator;
import java.util.logging.Logger;

public class GlobalBuildStatsXStreamConverter
implements Converter {
    private static final Logger LOGGER = Logger.getLogger(GlobalBuildStatsXStreamConverter.class.getName());
    public static final String BUILD_STAT_CONFIG_CLASS_ALIAS = "bsc";
    public static final String JOB_BUILD_RESULT_CLASS_ALIAS = "jbr";
    public static final String RETENTION_STRATEGY_CLASS_ALIAS = "rs";
    public static final String BUILD_SEARCH_CRITERIA_CLASS_ALIAS = "bscr";
    public static final String HISTORIC_SCALE_CLASS_ALIAS = "GBS_HS";
    public static final String YAXIS_CHART_TYPE_CLASS_ALIAS = "GBS_YACT";
    public static final String YAXIS_CHART_DIMENSION_CLASS_ALIAS = "GBS_YACD";
    private static final GlobalBuildStatsDataMigrator[] MIGRATORS = new GlobalBuildStatsDataMigrator[]{new InitialMigrator(), new V0ToV1Migrator(), new V1ToV2Migrator(), new V2ToV3Migrator(), new V3ToV4Migrator(), new V4ToV5Migrator(), new V5ToV6Migrator(), new V6ToV7Migrator(), new V7ToV8Migrator(), new V8ToV9Migrator()};

    public boolean canConvert(Class type) {
        return GlobalBuildStatsPlugin.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        GlobalBuildStatsPlugin plugin = (GlobalBuildStatsPlugin)((Object)source);
        writer.addAttribute("version", String.valueOf(GlobalBuildStatsXStreamConverter.getCurrentGlobalBuildStatsVersionNumber()));
        plugin.getJobBuildResultsSharder().applyQueuedResultsInFiles();
        writer.startNode("buildStatConfigs");
        if (plugin.getBuildStatConfigs() != null) {
            for (BuildStatConfiguration c : plugin.getBuildStatConfigs()) {
                writer.startNode(BUILD_STAT_CONFIG_CLASS_ALIAS);
                context.convertAnother((Object)c);
                writer.endNode();
            }
        }
        writer.endNode();
        writer.startNode("retentionStrategies");
        if (plugin.getRetentionStrategies() != null) {
            context.convertAnother(plugin.getRetentionStrategies());
        }
        writer.endNode();
    }

    private static int getCurrentGlobalBuildStatsVersionNumber() {
        return MIGRATORS.length - 1;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        GlobalBuildStatsPlugin plugin = context.currentObject() == null || !(context.currentObject() instanceof GlobalBuildStatsPlugin) ? new GlobalBuildStatsPlugin() : (GlobalBuildStatsPlugin)((Object)context.currentObject());
        String version = reader.getAttribute("version");
        int versionNumber = 0;
        if (version != null) {
            versionNumber = Integer.parseInt(version);
        }
        if (versionNumber != GlobalBuildStatsXStreamConverter.getCurrentGlobalBuildStatsVersionNumber()) {
            LOGGER.info("Your version of persisted GlobalBuildStatsPlugin data is not up-to-date (v" + versionNumber + " < v" + GlobalBuildStatsXStreamConverter.getCurrentGlobalBuildStatsVersionNumber() + ") : data will be migrated !");
        }
        Object pojo = MIGRATORS[versionNumber].readGlobalBuildStatsPOJO(reader, context);
        for (int i = versionNumber + 1; i < GlobalBuildStatsXStreamConverter.getCurrentGlobalBuildStatsVersionNumber() + 1; ++i) {
            pojo = MIGRATORS[i].migrate(pojo);
        }
        this.populateGlobalBuildStatsPlugin(plugin, (GlobalBuildStatsPOJO)pojo);
        return plugin;
    }

    protected void populateGlobalBuildStatsPlugin(GlobalBuildStatsPlugin plugin, GlobalBuildStatsPOJO pojo) {
        plugin.getBuildStatConfigs().clear();
        plugin.getBuildStatConfigs().addAll(pojo.getBuildStatConfigs());
        plugin.getRetentionStrategies().clear();
        plugin.getRetentionStrategies().addAll(pojo.getRetentionStrategies());
        plugin.reloadJobBuildResults(pojo.getJobBuildResults());
    }
}

