/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionsUtil {
    public static <T> List<T> minus(List<T> initialList, List<T> elementsToRemove) {
        ArrayList<T> minusedList = new ArrayList<T>(initialList);
        minusedList.removeAll(elementsToRemove);
        return minusedList;
    }

    public static <T> Set<T> toSet(List<T> list) {
        HashSet<T> set = new HashSet<T>();
        for (T t : list) {
            if (set.contains(t)) continue;
            set.add(t);
        }
        return set;
    }

    public static <T, U> void mapMergeAdd(Map<T, List<U>> map, Map<T, List<U>> mapToAdd) {
        for (Map.Entry<T, List<U>> e : mapToAdd.entrySet()) {
            if (!map.containsKey(e.getKey())) {
                map.put(e.getKey(), new ArrayList());
            }
            map.get(e.getKey()).addAll((Collection)e.getValue());
        }
    }

    public static <T, U> void mapMergeRemove(Map<T, List<U>> map, Map<T, List<U>> mapToRemove) {
        for (Map.Entry<T, List<U>> e : mapToRemove.entrySet()) {
            if (!map.containsKey(e.getKey())) continue;
            map.get(e.getKey()).removeAll((Collection)e.getValue());
            if (!map.get(e.getKey()).isEmpty()) continue;
            map.remove(e.getKey());
        }
    }
}

