/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.rententionstrategies;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import hudson.plugins.global_build_stats.business.GlobalBuildStatsPluginSaver;
import hudson.plugins.global_build_stats.rententionstrategies.DiscardResultsOlderThanDays;
import hudson.plugins.global_build_stats.rententionstrategies.DoNotKeepBuildResultWhenDiscarded;
import hudson.plugins.global_build_stats.rententionstrategies.KeepExistingJobResultsOnly;
import hudson.plugins.global_build_stats.rententionstrategies.strategybehaviours.BuildCompletedListener;
import hudson.plugins.global_build_stats.rententionstrategies.strategybehaviours.BuildDeletedListener;
import hudson.plugins.global_build_stats.rententionstrategies.strategybehaviours.ParameterizedStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class RetentionStrategy<T extends RetentionStrategy> {
    @SuppressFBWarnings(value={"MS_MUTABLE_COLLECTION_PKGPROTECT"})
    protected static final List<RetentionStrategy> RETENTION_STRATEGIES_IMPLEMENTATIONS = new ArrayList<RetentionStrategy>(){
        {
            this.add(new DiscardResultsOlderThanDays());
            this.add(new DoNotKeepBuildResultWhenDiscarded());
            this.add(new KeepExistingJobResultsOnly());
        }
    };

    protected RetentionStrategy() {
    }

    public String getId() {
        return this.getClass().getName();
    }

    public abstract String getConfigPage();

    public static RetentionStrategy valueOf(String strategyId) {
        for (RetentionStrategy strategy : RETENTION_STRATEGIES_IMPLEMENTATIONS) {
            if (!strategyId.equals(strategy.getId())) continue;
            return strategy;
        }
        return null;
    }

    public void updateState(Map<String, String[]> parameters) {
        if (this instanceof ParameterizedStrategy) {
            ((ParameterizedStrategy)((Object)this)).updateStrategyParameters(parameters);
        }
    }

    public void from(T strategyToCopy) {
        if (this instanceof ParameterizedStrategy) {
            ((ParameterizedStrategy)((Object)this)).updateStrategyParameters(strategyToCopy);
        }
    }

    public void onBuildDeleted(Run<?, ?> build, GlobalBuildStatsPluginSaver pluginSaver) {
        if (this instanceof BuildDeletedListener) {
            ((BuildDeletedListener)((Object)this)).buildDeleted(build, pluginSaver);
        }
    }

    public void onBuildCompleted(Run<?, ?> build, GlobalBuildStatsPluginSaver pluginSaver) {
        if (this instanceof BuildCompletedListener) {
            ((BuildCompletedListener)((Object)this)).buildCompleted(build, pluginSaver);
        }
    }

    public static List<RetentionStrategy> values() {
        return RETENTION_STRATEGIES_IMPLEMENTATIONS;
    }

    public abstract void strategyActivated(GlobalBuildStatsPluginSaver var1);
}

