/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.rententionstrategies;

import hudson.model.Run;
import hudson.plugins.global_build_stats.GlobalBuildStatsPlugin;
import hudson.plugins.global_build_stats.business.GlobalBuildStatsPluginSaver;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.plugins.global_build_stats.rententionstrategies.RetentionStrategy;
import hudson.plugins.global_build_stats.rententionstrategies.strategybehaviours.BuildCompletedListener;
import hudson.plugins.global_build_stats.rententionstrategies.strategybehaviours.ParameterizedStrategy;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class DiscardResultsOlderThanDays
extends RetentionStrategy<DiscardResultsOlderThanDays>
implements ParameterizedStrategy<DiscardResultsOlderThanDays>,
BuildCompletedListener {
    private static final long PURGE_FREQUENCY = 86400000L;
    private long days = 365L;
    private transient Date lastPurgeDate = null;

    @Override
    public String getConfigPage() {
        return "discardResultsOlderThanDays.jelly";
    }

    public long getDays() {
        return this.days;
    }

    @Override
    public void updateStrategyParameters(Map<String, String[]> parameters) {
        this.days = Long.parseLong(parameters.get("discardResultsOlderThanDays")[0]);
    }

    @Override
    public void updateStrategyParameters(DiscardResultsOlderThanDays otherStrategyToCopy) {
        this.days = otherStrategyToCopy.days;
    }

    @Override
    public void strategyActivated(GlobalBuildStatsPluginSaver pluginSaver) {
        this.purgeOldBuildResults(pluginSaver, System.currentTimeMillis());
    }

    @Override
    public void buildCompleted(Run<?, ?> buils, GlobalBuildStatsPluginSaver pluginSaver) {
        long now = System.currentTimeMillis();
        if (this.lastPurgeDate == null || now > this.lastPurgeDate.getTime() + 86400000L) {
            this.purgeOldBuildResults(pluginSaver, now);
        }
    }

    protected void purgeOldBuildResults(GlobalBuildStatsPluginSaver pluginSaver, final long now) {
        pluginSaver.updatePlugin(new GlobalBuildStatsPluginSaver.BeforeSavePluginCallback(){

            @Override
            public void changePluginStateBeforeSavingIt(GlobalBuildStatsPlugin plugin) {
                ArrayList<JobBuildResult> jobBuildResultsToRemove = new ArrayList<JobBuildResult>();
                for (JobBuildResult jbr : plugin.getJobBuildResults()) {
                    if (jbr.getBuildDate().getTimeInMillis() + DiscardResultsOlderThanDays.this.days * 24L * 3600L * 1000L >= now) continue;
                    jobBuildResultsToRemove.add(jbr);
                }
                plugin.getJobBuildResultsSharder().queueResultsToRemove(jobBuildResultsToRemove);
            }
        });
        this.lastPurgeDate = new Date(now);
    }
}

