/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Hudson;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.plugins.global_build_stats.util.CollectionsUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class JobBuildResultSharder {
    private static final Logger LOGGER = Logger.getLogger(JobBuildResultSharder.class.getName());
    private static final String GBS_ROOT_PATH = "global-build-stats";
    private static final String GBS_JOBRESULTS_PATH = "jobresults";
    private final List<JobBuildResult> queuedResultsToAdd = Collections.synchronizedList(new ArrayList());
    private final List<JobBuildResult> queuedResultsToRemove = Collections.synchronizedList(new ArrayList());
    private final List<JobBuildResult> persistedResults;
    private final Map<String, List<JobBuildResult>> persistedMonthlyResults;

    public JobBuildResultSharder() {
        this(null, new ArrayList<JobBuildResult>());
    }

    public JobBuildResultSharder(JobBuildResultSharder sharder, List<JobBuildResult> jobBuildResults) {
        this.persistedResults = Collections.synchronizedList(jobBuildResults);
        this.persistedMonthlyResults = Collections.synchronizedMap(JobBuildResultSharder.toJobResultFilenameMap(jobBuildResults));
        if (sharder != null) {
            this.queueResultsToAdd(sharder.queuedResultsToAdd);
            this.queueResultsToRemove(sharder.queuedResultsToRemove);
        }
    }

    public void queueResultToAdd(JobBuildResult result) {
        this.queuedResultsToAdd.add(result);
    }

    public void queueResultsToAdd(List<JobBuildResult> results) {
        this.queuedResultsToAdd.addAll(results);
    }

    public void queueResultToRemove(JobBuildResult result) {
        this.queuedResultsToRemove.add(result);
    }

    public void queueResultsToRemove(List<JobBuildResult> results) {
        this.queuedResultsToRemove.addAll(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public void applyQueuedResultsInFiles() {
        ArrayList<JobBuildResult> resultsToRemove;
        ArrayList<JobBuildResult> resultsToAdd;
        LOGGER.log(Level.FINER, "Processing job results update queue ...");
        List<JobBuildResult> list = this.queuedResultsToAdd;
        synchronized (list) {
            resultsToAdd = new ArrayList<JobBuildResult>(this.queuedResultsToAdd);
            this.queuedResultsToAdd.clear();
        }
        List<JobBuildResult> list2 = this.queuedResultsToRemove;
        synchronized (list2) {
            resultsToRemove = new ArrayList<JobBuildResult>(this.queuedResultsToRemove);
            this.queuedResultsToRemove.clear();
        }
        if (resultsToAdd.isEmpty() && resultsToRemove.isEmpty()) {
            LOGGER.log(Level.FINER, "No change detected in job results update queue !");
            return;
        }
        File jobResultsRoot = JobBuildResultSharder.getJobResultFolder();
        if (!jobResultsRoot.exists()) {
            try {
                FileUtils.forceMkdir((File)jobResultsRoot);
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't create job results root directory : " + jobResultsRoot.getAbsolutePath(), e);
            }
        }
        this.removePersistedJobResults(resultsToRemove);
        this.addPersistedJobResults(resultsToAdd);
        ArrayList<String> updatedFilenamesList = new ArrayList<String>(JobBuildResultSharder.toJobResultFilenameMap(resultsToRemove).keySet());
        updatedFilenamesList.addAll(JobBuildResultSharder.toJobResultFilenameMap(resultsToAdd).keySet());
        Set<String> updatedFilenames = CollectionsUtil.toSet(updatedFilenamesList);
        for (String filename : updatedFilenames) {
            String jobResultFilepath = jobResultsRoot.getAbsolutePath() + File.separator + filename;
            try {
                FileWriter fw = new FileWriter(jobResultFilepath);
                Hudson.XSTREAM.toXML(this.persistedMonthlyResults.get(filename), (Writer)fw);
                fw.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Unable to serialize job results into " + jobResultFilepath, e);
                throw new IllegalStateException("Unable to serialize job results into " + jobResultFilepath, e);
            }
        }
        LOGGER.log(Level.FINER, "Queued changes applied on job results !");
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE", "DM_DEFAULT_ENCODING"})
    public static List<JobBuildResult> load() {
        ArrayList<JobBuildResult> jobBuildResults = new ArrayList<JobBuildResult>();
        File jobResultsRoot = JobBuildResultSharder.getJobResultFolder();
        if (jobResultsRoot.exists()) {
            for (File f : jobResultsRoot.listFiles()) {
                try {
                    FileReader fr = new FileReader(f);
                    List jobResultsInFile = (List)Hudson.XSTREAM.fromXML((Reader)fr);
                    jobBuildResults.addAll(jobResultsInFile);
                    fr.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Unable to read job results in " + f.getAbsolutePath(), e);
                    throw new IllegalStateException("Unable to read job results in " + f.getAbsolutePath(), e);
                }
            }
        }
        Collections.sort(jobBuildResults, new JobBuildResult.AntiChronologicalComparator());
        return jobBuildResults;
    }

    private synchronized void addPersistedJobResults(List<JobBuildResult> results) {
        this.persistedResults.addAll(results);
        Map<String, List<JobBuildResult>> filenameMap = JobBuildResultSharder.toJobResultFilenameMap(results);
        CollectionsUtil.mapMergeAdd(this.persistedMonthlyResults, filenameMap);
    }

    private synchronized void removePersistedJobResults(List<JobBuildResult> results) {
        this.persistedResults.removeAll(results);
        Map<String, List<JobBuildResult>> filenameMap = JobBuildResultSharder.toJobResultFilenameMap(results);
        CollectionsUtil.mapMergeRemove(this.persistedMonthlyResults, filenameMap);
    }

    public List<JobBuildResult> getJobBuildResults() {
        ArrayList<JobBuildResult> aggregatedList = new ArrayList<JobBuildResult>(this.persistedResults);
        aggregatedList.removeAll(this.queuedResultsToRemove);
        aggregatedList.addAll(this.queuedResultsToAdd);
        return Collections.unmodifiableList(aggregatedList);
    }

    public boolean pendingChanges() {
        return !this.queuedResultsToAdd.isEmpty() || !this.queuedResultsToRemove.isEmpty();
    }

    private static Map<String, List<JobBuildResult>> toJobResultFilenameMap(List<JobBuildResult> results) {
        HashMap<String, List<JobBuildResult>> byMonthJobResults = new HashMap<String, List<JobBuildResult>>();
        SimpleDateFormat yearMonth = new SimpleDateFormat("yyyy-MM");
        for (JobBuildResult r : results) {
            String targetFilename = "jobResults-" + yearMonth.format(r.getBuildDate().getTime()) + ".xml";
            if (!byMonthJobResults.containsKey(targetFilename)) {
                byMonthJobResults.put(targetFilename, new ArrayList());
            }
            ((List)byMonthJobResults.get(targetFilename)).add(r);
        }
        return byMonthJobResults;
    }

    private static File getJobResultFolder() {
        return new File(Hudson.getInstance().getRootDir().getAbsolutePath() + File.separator + GBS_ROOT_PATH + File.separator + GBS_JOBRESULTS_PATH);
    }
}

