/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import hudson.plugins.global_build_stats.Messages;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.model.DateRange;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.util.DataSetBuilder;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;

public abstract class AbstractBuildStatChartDimension {
    protected BuildStatConfiguration config;
    protected DataSetBuilder<String, DateRange> datasetBuilder;
    private static final LegendItemData[] BUILD_STATUSES_LEGENDITEMS = new LegendItemData[]{new LegendItemData(Messages.Build_Results_Item_Legend_Statuses_NOT_BUILD(), new Color(85, 85, 85)), new LegendItemData(Messages.Build_Results_Item_Legend_Statuses_FAILURES(), new Color(255, 85, 85)), new LegendItemData(Messages.Build_Results_Item_Legend_Statuses_ABORTED(), new Color(255, 85, 255)), new LegendItemData(Messages.Build_Results_Item_Legend_Statuses_UNSTABLES(), new Color(255, 255, 85)), new LegendItemData(Messages.Build_Results_Item_Legend_Statuses_SUCCESS(), new Color(85, 85, 255))};
    private static final LegendItemData TOTAL_BUILD_TIME_LEGENDITEM = new LegendItemData(Messages.Build_Results_Total_Build_Time(), new Color(0, 0, 0));
    private static final LegendItemData AVERAGE_BUILD_TIME_LEGENDITEM = new LegendItemData(Messages.Build_Results_Average_Build_Time(), new Color(128, 255, 255));

    protected AbstractBuildStatChartDimension(BuildStatConfiguration config, DataSetBuilder<String, DateRange> datasetBuilder) {
        this.config = config;
        this.datasetBuilder = datasetBuilder;
    }

    public DataSetBuilder<String, DateRange> getDatasetBuilder() {
        return this.datasetBuilder;
    }

    public static List<LegendItemData> getSortedLegendItemsLabels() {
        ArrayList<LegendItemData> sortedLegendItemsLabels = new ArrayList<LegendItemData>();
        for (int i = 0; i < BUILD_STATUSES_LEGENDITEMS.length; ++i) {
            sortedLegendItemsLabels.add(BUILD_STATUSES_LEGENDITEMS[i]);
        }
        sortedLegendItemsLabels.add(TOTAL_BUILD_TIME_LEGENDITEM);
        sortedLegendItemsLabels.add(AVERAGE_BUILD_TIME_LEGENDITEM);
        return sortedLegendItemsLabels;
    }

    public abstract void provideDataInDataSet(DateRange var1);

    public abstract void saveDataForBuild(JobBuildResult var1);

    public abstract CategoryItemRenderer getRenderer();

    public abstract ValueAxis getRangeAxis();

    public static class LegendItemData {
        public String label;
        public Color color;

        public LegendItemData(String label, Color color) {
            this.label = label;
            this.color = color;
        }
    }

    public static class BuildAverageDurationChartDimension
    extends AbstractBuildStatChartDimension {
        private int buildCounter = 0;
        private long totalBuildDuration = 0L;

        public BuildAverageDurationChartDimension(BuildStatConfiguration config, DataSetBuilder<String, DateRange> datasetBuilder) {
            super(config, datasetBuilder);
        }

        @Override
        public void saveDataForBuild(JobBuildResult currentBuild) {
            if (!currentBuild.isDurationEmpty()) {
                ++this.buildCounter;
                this.totalBuildDuration += currentBuild.getDuration();
            }
        }

        @Override
        public void provideDataInDataSet(DateRange range) {
            this.datasetBuilder.add((Number)(this.buildCounter == 0 ? 0.0 : Long.valueOf(this.totalBuildDuration).doubleValue() / ((double)this.buildCounter * 1000.0)), (Comparable)((Object)Messages.Build_Results_Average_Build_Time()), (Comparable)range);
            this.buildCounter = 0;
            this.totalBuildDuration = 0L;
        }

        @Override
        public CategoryItemRenderer getRenderer() {
            LineAndShapeRenderer renderer = new LineAndShapeRenderer();
            renderer.setSeriesPaint(0, (Paint)AbstractBuildStatChartDimension.AVERAGE_BUILD_TIME_LEGENDITEM.color);
            return renderer;
        }

        @Override
        public ValueAxis getRangeAxis() {
            return new NumberAxis(Messages.YAxis_Chart_Types_Average_Duration_Time());
        }
    }

    public static class BuildTotalDurationChartDimension
    extends AbstractBuildStatChartDimension {
        private long totalBuildDuration = 0L;

        public BuildTotalDurationChartDimension(BuildStatConfiguration config, DataSetBuilder<String, DateRange> datasetBuilder) {
            super(config, datasetBuilder);
        }

        @Override
        public void saveDataForBuild(JobBuildResult currentBuild) {
            if (!currentBuild.isDurationEmpty()) {
                this.totalBuildDuration += currentBuild.getDuration();
            }
        }

        @Override
        public void provideDataInDataSet(DateRange range) {
            this.datasetBuilder.add((Number)(Long.valueOf(this.totalBuildDuration).doubleValue() / 1000.0), (Comparable)((Object)Messages.Build_Results_Total_Build_Time()), (Comparable)range);
            this.totalBuildDuration = 0L;
        }

        @Override
        public CategoryItemRenderer getRenderer() {
            LineAndShapeRenderer renderer = new LineAndShapeRenderer();
            renderer.setSeriesPaint(0, (Paint)AbstractBuildStatChartDimension.TOTAL_BUILD_TIME_LEGENDITEM.color);
            return renderer;
        }

        @Override
        public ValueAxis getRangeAxis() {
            return new NumberAxis(Messages.YAxis_Chart_Types_Total_Duration_Time());
        }
    }

    public static class BuildCounterChartDimension
    extends AbstractBuildStatChartDimension {
        private int nbSuccess = 0;
        private int nbFailures = 0;
        private int nbUnstables = 0;
        private int nbAborted = 0;
        private int nbNotBuild = 0;

        public BuildCounterChartDimension(BuildStatConfiguration config, DataSetBuilder<String, DateRange> datasetBuilder) {
            super(config, datasetBuilder);
        }

        @Override
        public void provideDataInDataSet(DateRange range) {
            this.config.getyAxisChartType().provideDataInDataSet((DataSetBuilder<String, DateRange>)this.datasetBuilder, range, this.nbSuccess, this.nbFailures, this.nbUnstables, this.nbAborted, this.nbNotBuild);
            this.nbSuccess = 0;
            this.nbFailures = 0;
            this.nbUnstables = 0;
            this.nbAborted = 0;
            this.nbNotBuild = 0;
        }

        @Override
        public void saveDataForBuild(JobBuildResult currentBuild) {
            this.nbSuccess += currentBuild.getResult().getSuccessCount();
            this.nbFailures += currentBuild.getResult().getFailureCount();
            this.nbUnstables += currentBuild.getResult().getUnstableCount();
            this.nbAborted += currentBuild.getResult().getAbortedCount();
            this.nbNotBuild += currentBuild.getResult().getNotBuildCount();
        }

        @Override
        public CategoryItemRenderer getRenderer() {
            StackedAreaRenderer2 renderer = new StackedAreaRenderer2(){

                public String generateURL(CategoryDataset dataset, int row, int column) {
                    DateRange range = (DateRange)dataset.getColumnKey(column);
                    String status = (String)((Object)dataset.getRowKey(row));
                    boolean successShown = Messages.Build_Results_Item_Legend_Statuses_SUCCESS().equals(status);
                    boolean failuresShown = Messages.Build_Results_Item_Legend_Statuses_FAILURES().equals(status);
                    boolean unstablesShown = Messages.Build_Results_Item_Legend_Statuses_UNSTABLES().equals(status);
                    boolean abortedShown = Messages.Build_Results_Item_Legend_Statuses_ABORTED().equals(status);
                    boolean notBuildShown = Messages.Build_Results_Item_Legend_Statuses_NOT_BUILD().equals(status);
                    StringBuilder sb = new StringBuilder().append("buildHistory?jobFilter=").append(URLEncoder.encode(config.getBuildFilters().getJobFilter())).append("&start=").append(range.getStart().getTimeInMillis()).append("&end=").append(range.getEnd().getTimeInMillis()).append("&successShown=").append(successShown).append("&failuresShown=").append(failuresShown).append("&unstablesShown=").append(unstablesShown).append("&abortedShown=").append(abortedShown).append("&notBuildShown=").append(notBuildShown);
                    if (config.getBuildFilters().getNodeFilter() != null) {
                        sb.append("&nodeFilter=").append(URLEncoder.encode(config.getBuildFilters().getNodeFilter()));
                    }
                    if (config.getBuildFilters().getLauncherFilter() != null) {
                        sb.append("&launcherFilter=").append(URLEncoder.encode(config.getBuildFilters().getLauncherFilter()));
                    }
                    return sb.toString();
                }
            };
            for (int i = 0; i < BUILD_STATUSES_LEGENDITEMS.length; ++i) {
                renderer.setSeriesPaint(i, (Paint)AbstractBuildStatChartDimension.BUILD_STATUSES_LEGENDITEMS[i].color);
            }
            return renderer;
        }

        @Override
        public ValueAxis getRangeAxis() {
            return new NumberAxis(this.config.getyAxisChartType().getLabel());
        }
    }
}

