/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.business;

import com.thoughtworks.xstream.converters.Converter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Hudson;
import hudson.plugins.global_build_stats.GlobalBuildStatsPlugin;
import hudson.plugins.global_build_stats.model.BuildSearchCriteria;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.model.HistoricScale;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.plugins.global_build_stats.model.YAxisChartDimension;
import hudson.plugins.global_build_stats.model.YAxisChartType;
import hudson.plugins.global_build_stats.rententionstrategies.DiscardResultsOlderThanDays;
import hudson.plugins.global_build_stats.rententionstrategies.DoNotKeepBuildResultWhenDiscarded;
import hudson.plugins.global_build_stats.rententionstrategies.KeepExistingJobResultsOnly;
import hudson.plugins.global_build_stats.rententionstrategies.RetentionStrategy;
import hudson.plugins.global_build_stats.xstream.GlobalBuildStatsXStreamConverter;
import hudson.util.DaemonThreadFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlobalBuildStatsPluginSaver {
    private static final Logger LOGGER = Logger.getLogger(GlobalBuildStatsPluginSaver.class.getName());
    private GlobalBuildStatsPlugin plugin;
    final ExecutorService writer = Executors.newFixedThreadPool(1, (ThreadFactory)new DaemonThreadFactory());

    public GlobalBuildStatsPluginSaver(GlobalBuildStatsPlugin plugin) {
        this.plugin = plugin;
        this.initializeXStream();
    }

    private void initializeXStream() {
        Hudson.XSTREAM.registerConverter((Converter)new GlobalBuildStatsXStreamConverter());
        Hudson.XSTREAM.alias("jbr", JobBuildResult.class);
        Hudson.XSTREAM.alias("bsc", BuildStatConfiguration.class);
        Hudson.XSTREAM.alias("bscr", BuildSearchCriteria.class);
        Hudson.XSTREAM.alias("GBS_HS", HistoricScale.class);
        Hudson.XSTREAM.alias("GBS_YACT", YAxisChartType.class);
        Hudson.XSTREAM.alias("GBS_YACD", YAxisChartDimension.class);
        Hudson.XSTREAM.alias("discardResultsOlderThanDays", DiscardResultsOlderThanDays.class);
        Hudson.XSTREAM.alias("doNotKeepBuildResultWhenDiscarded", DoNotKeepBuildResultWhenDiscarded.class);
        Hudson.XSTREAM.alias("keepExistingJobResultsOnly", KeepExistingJobResultsOnly.class);
        Hudson.XSTREAM.aliasField("t", BuildStatConfiguration.class, "buildStatTitle");
        Hudson.XSTREAM.aliasField("w", BuildStatConfiguration.class, "buildStatWidth");
        Hudson.XSTREAM.aliasField("h", BuildStatConfiguration.class, "buildStatHeight");
        Hudson.XSTREAM.aliasField("l", BuildStatConfiguration.class, "historicLength");
        Hudson.XSTREAM.aliasField("s", BuildStatConfiguration.class, "historicScale");
        Hudson.XSTREAM.aliasField("yact", BuildStatConfiguration.class, "yAxisChartType");
        Hudson.XSTREAM.aliasField("ds", BuildStatConfiguration.class, "dimensionsShown");
        Hudson.XSTREAM.aliasField("f", BuildStatConfiguration.class, "buildFilters");
        Hudson.XSTREAM.aliasField("jf", BuildStatConfiguration.class, "jobFilter");
        Hudson.XSTREAM.aliasField("sbr", BuildStatConfiguration.class, "shownBuildResults");
        Hudson.XSTREAM.aliasField("jf", BuildSearchCriteria.class, "jobFilter");
        Hudson.XSTREAM.aliasField("nf", BuildSearchCriteria.class, "nodeFilter");
        Hudson.XSTREAM.aliasField("lf", BuildSearchCriteria.class, "launcherFilter");
        Hudson.XSTREAM.aliasField("sbr", BuildSearchCriteria.class, "shownBuildResults");
        Hudson.XSTREAM.aliasField("r", JobBuildResult.class, "result");
        Hudson.XSTREAM.aliasField("n", JobBuildResult.class, "jobName");
        Hudson.XSTREAM.aliasField("nb", JobBuildResult.class, "buildNumber");
        Hudson.XSTREAM.aliasField("d", JobBuildResult.class, "buildDate");
        Hudson.XSTREAM.aliasField("du", JobBuildResult.class, "duration");
        Hudson.XSTREAM.aliasField("nn", JobBuildResult.class, "nodeName");
        Hudson.XSTREAM.aliasField("un", JobBuildResult.class, "userName");
    }

    @SuppressFBWarnings
    public void reloadPlugin() {
        try {
            this.plugin.load();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (NullPointerException x) {
            File f = this.plugin.getConfigXmlFile();
            File bak = new File(f.getParentFile(), f.getName() + ".bak");
            if (!f.renameTo(bak)) {
                LOGGER.log(Level.WARNING, "failed to rename {0} to {1}", new Object[]{f, bak});
            }
            LOGGER.log(Level.WARNING, "JENKINS-17248 load failure; saving problematic file to " + String.valueOf(bak), x);
        }
    }

    public void updatePlugin(BeforeSavePluginCallback callback) {
        final ArrayList<BuildStatConfiguration> configsBeforeStateChange = new ArrayList<BuildStatConfiguration>(this.plugin.getBuildStatConfigs());
        final ArrayList<RetentionStrategy> retentionStrategiesBeforeStateChange = new ArrayList<RetentionStrategy>(this.plugin.getRetentionStrategies());
        callback.changePluginStateBeforeSavingIt(this.plugin);
        LOGGER.log(Level.FINER, "Global build stats state update queued !");
        this.writer.submit(new Runnable(){

            @Override
            public void run() {
                if (configsBeforeStateChange.equals(GlobalBuildStatsPluginSaver.this.plugin.getBuildStatConfigs()) && retentionStrategiesBeforeStateChange.equals(GlobalBuildStatsPluginSaver.this.plugin.getRetentionStrategies()) && !GlobalBuildStatsPluginSaver.this.plugin.getJobBuildResultsSharder().pendingChanges()) {
                    LOGGER.log(Level.FINER, "No change detected in update queue !");
                    return;
                }
                try {
                    GlobalBuildStatsPluginSaver.this.plugin.save();
                    LOGGER.log(Level.FINER, "Changes applied and file saved !");
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to persist global build stat records", e);
                }
            }
        });
    }

    public static abstract class BeforeSavePluginCallback {
        public abstract void changePluginStateBeforeSavingIt(GlobalBuildStatsPlugin var1);

        public void afterPluginSaved() {
        }
    }
}

