/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats;

import hudson.Extension;
import hudson.Plugin;
import hudson.model.Api;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.global_build_stats.FromRequestObjectFactory;
import hudson.plugins.global_build_stats.Messages;
import hudson.plugins.global_build_stats.business.GlobalBuildStatsBusiness;
import hudson.plugins.global_build_stats.model.AbstractBuildStatChartDimension;
import hudson.plugins.global_build_stats.model.BuildHistorySearchCriteria;
import hudson.plugins.global_build_stats.model.BuildStatChartData;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.model.HistoricScale;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.plugins.global_build_stats.model.JobBuildResultSharder;
import hudson.plugins.global_build_stats.model.JobBuildSearchResult;
import hudson.plugins.global_build_stats.model.ModelIdGenerator;
import hudson.plugins.global_build_stats.model.YAxisChartType;
import hudson.plugins.global_build_stats.rententionstrategies.RetentionStrategy;
import hudson.plugins.global_build_stats.validation.GlobalBuildStatsValidator;
import hudson.security.Permission;
import hudson.util.ChartUtil;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public class GlobalBuildStatsPlugin
extends Plugin {
    private static final Logger LOGGER = Logger.getLogger(GlobalBuildStatsPlugin.class.getName());
    private JobBuildResultSharder jobBuildResultsSharder = new JobBuildResultSharder();
    @Deprecated
    private transient List<JobBuildResult> jobBuildResults = new ArrayList<JobBuildResult>();
    private List<BuildStatConfiguration> buildStatConfigs = new ArrayList<BuildStatConfiguration>();
    private List<RetentionStrategy> retentionStrategies = new ArrayList<RetentionStrategy>();
    private final transient GlobalBuildStatsBusiness business = new GlobalBuildStatsBusiness(this);
    private final transient GlobalBuildStatsValidator validator = new GlobalBuildStatsValidator();
    private static final String CONTENT_TYPE = "application/json";

    public Api getApi() {
        return new GlobalBuildStatsApi((Object)this);
    }

    public void load() throws IOException {
        super.load();
    }

    public File getConfigXmlFile() {
        return this.getConfigXml().getFile();
    }

    public static GlobalBuildStatsBusiness getPluginBusiness() {
        return GlobalBuildStatsPlugin.getInstance().business;
    }

    public static GlobalBuildStatsPlugin getInstance() {
        return (GlobalBuildStatsPlugin)Hudson.getInstance().getPlugin(GlobalBuildStatsPlugin.class);
    }

    public FormValidation doCheckJobFilter(@QueryParameter String value) {
        return this.validator.checkJobFilter(value);
    }

    public FormValidation doCheckFailuresShown(@QueryParameter String value) {
        return this.validator.checkFailuresShown(value);
    }

    public FormValidation doCheckUnstablesShown(@QueryParameter String value) {
        return this.validator.checkUnstablesShown(value);
    }

    public FormValidation doCheckAbortedShown(@QueryParameter String value) {
        return this.validator.checkAbortedShown(value);
    }

    public FormValidation doCheckNotBuildsShown(@QueryParameter String value) {
        return this.validator.checkNotBuildsShown(value);
    }

    public FormValidation doCheckSuccessShown(@QueryParameter String value) {
        return this.validator.checkSuccessShown(value);
    }

    public FormValidation doCheckHistoricScale(@QueryParameter String value) {
        return this.validator.checkHistoricScale(value);
    }

    public FormValidation doCheckHistoricLength(@QueryParameter String value) {
        return this.validator.checkHistoricLength(value);
    }

    public FormValidation doCheckBuildStatHeight(@QueryParameter String value) {
        return this.validator.checkBuildStatHeight(value);
    }

    public FormValidation doCheckBuildStatWidth(@QueryParameter String value) {
        return this.validator.checkBuildStatWidth(value);
    }

    public FormValidation doCheckTitle(@QueryParameter String value) {
        return this.validator.checkTitle(value);
    }

    public FormValidation doCheckYAxisChartType(@QueryParameter String value) {
        return this.validator.checkYAxisChartType(value);
    }

    public HttpResponse doRecordBuildInfos() throws IOException {
        Hudson.getInstance().checkPermission(GlobalBuildStatsPlugin.getRequiredPermission());
        this.business.recordBuildInfos();
        return new HttpResponse(){

            public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
            }
        };
    }

    public void doShowChart(StaplerRequest2 req, StaplerResponse2 res) throws ServletException, IOException {
        BuildStatConfiguration config = this.business.searchBuildStatConfigById(req.getParameter("buildStatId"));
        if (config == null) {
            throw new IllegalArgumentException("Unknown buildStatId parameter !");
        }
        JFreeChart chart = this.business.createChart(config);
        ChartUtil.generateGraph((StaplerRequest)StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), (StaplerResponse)StaplerResponse.fromStaplerResponse2((StaplerResponse2)res), (JFreeChart)chart, (int)config.getBuildStatWidth(), (int)config.getBuildStatHeight());
    }

    public void doCreateChart(StaplerRequest2 req, StaplerResponse2 res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(GlobalBuildStatsPlugin.getRequiredPermission());
        BuildStatConfiguration config = FromRequestObjectFactory.createBuildStatConfiguration(null, req);
        JFreeChart chart = this.business.createChart(config);
        ChartUtil.generateGraph((StaplerRequest)StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), (StaplerResponse)StaplerResponse.fromStaplerResponse2((StaplerResponse2)res), (JFreeChart)chart, (int)config.getBuildStatWidth(), (int)config.getBuildStatHeight());
    }

    public void doCreateChartMap(StaplerRequest2 req, StaplerResponse2 res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(GlobalBuildStatsPlugin.getRequiredPermission());
        String buildStatId = req.getParameter("buildStatId");
        BuildStatConfiguration config = buildStatId != null ? this.business.searchBuildStatConfigById(buildStatId) : FromRequestObjectFactory.createBuildStatConfiguration(null, req);
        JFreeChart chart = this.business.createChart(config);
        ChartUtil.generateClickableMap((StaplerRequest)StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), (StaplerResponse)StaplerResponse.fromStaplerResponse2((StaplerResponse2)res), (JFreeChart)chart, (int)config.getBuildStatWidth(), (int)config.getBuildStatHeight());
    }

    public void doBuildHistory(StaplerRequest2 req, StaplerResponse2 res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(GlobalBuildStatsPlugin.getRequiredPermission());
        BuildHistorySearchCriteria searchCriteria = FromRequestObjectFactory.createBuildHistorySearchCriteria(req);
        List<JobBuildSearchResult> filteredJobBuildResults = this.business.searchBuilds(searchCriteria);
        req.setAttribute("jobResults", filteredJobBuildResults);
        req.setAttribute("searchCriteria", (Object)searchCriteria);
        req.getView((Object)this, "/hudson/plugins/global_build_stats/GlobalBuildStatsPlugin/buildHistory.jelly").forward((ServletRequest)req, (ServletResponse)res);
    }

    @RequirePOST
    public void doUpdateBuildStatConfiguration(StaplerRequest2 req, StaplerResponse2 res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(GlobalBuildStatsPlugin.getRequiredPermission());
        boolean regenerateId = Boolean.parseBoolean(req.getParameter("regenerateId"));
        BuildStatConfiguration config = FromRequestObjectFactory.createBuildStatConfiguration(req.getParameter("buildStatId"), req);
        this.business.updateBuildStatConfiguration(req.getParameter("buildStatId"), config, regenerateId);
        String json = JSONObject.fromObject((Object)config).toString();
        res.setContentType(CONTENT_TYPE);
        res.getWriter().write(json);
    }

    @RequirePOST
    public void doAddBuildStatConfiguration(StaplerRequest2 req, StaplerResponse2 res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(GlobalBuildStatsPlugin.getRequiredPermission());
        BuildStatConfiguration config = FromRequestObjectFactory.createBuildStatConfiguration(ModelIdGenerator.INSTANCE.generateIdForClass(BuildStatConfiguration.class), req);
        this.business.addBuildStatConfiguration(config);
        String json = JSONObject.fromObject((Object)config).toString();
        res.setContentType(CONTENT_TYPE);
        res.getWriter().write(json);
    }

    @RequirePOST
    public void doDeleteConfiguration(StaplerRequest2 req, StaplerResponse2 res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(GlobalBuildStatsPlugin.getRequiredPermission());
        this.business.deleteBuildStatConfiguration(req.getParameter("buildStatId"));
        GlobalBuildStatsPlugin.respondAjaxOk(res);
    }

    @RequirePOST
    public void doMoveUpConf(StaplerRequest2 req, StaplerResponse2 res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(GlobalBuildStatsPlugin.getRequiredPermission());
        this.business.moveUpConf(req.getParameter("buildStatId"));
        GlobalBuildStatsPlugin.respondAjaxOk(res);
    }

    @RequirePOST
    public void doMoveDownConf(StaplerRequest2 req, StaplerResponse2 res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(GlobalBuildStatsPlugin.getRequiredPermission());
        this.business.moveDownConf(req.getParameter("buildStatId"));
        GlobalBuildStatsPlugin.respondAjaxOk(res);
    }

    @RequirePOST
    public void doUpdateRetentionStrategies(StaplerRequest2 req, StaplerResponse2 res) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(GlobalBuildStatsPlugin.getRequiredPermission());
        ArrayList<RetentionStrategy> selectedStrategies = new ArrayList<RetentionStrategy>();
        if (req.getParameterValues("retentionStrategies") != null) {
            for (String selectedStrategyId : req.getParameterValues("retentionStrategies")) {
                RetentionStrategy retentionStrategy = RetentionStrategy.valueOf(selectedStrategyId);
                retentionStrategy.updateState(req.getParameterMap());
                selectedStrategies.add(retentionStrategy);
            }
        }
        this.business.updateRetentionStrategies(selectedStrategies);
        GlobalBuildStatsPlugin.respondAjaxOk(res);
    }

    protected static void respondAjaxOk(StaplerResponse2 res) throws IOException {
        res.getWriter().write("{ status : 'ok' }");
    }

    public static String escapeAntiSlashes(String value) {
        return GlobalBuildStatsBusiness.escapeAntiSlashes(value);
    }

    public static String getFieldFilterALL() {
        return "ALL";
    }

    public static String getFieldFilterRegex() {
        return "fieldRegex";
    }

    public BuildStatConfiguration[] getBuildStatConfigsArrayed() {
        return this.buildStatConfigs.toArray(new BuildStatConfiguration[0]);
    }

    @Exported
    public List<BuildStatConfiguration> getBuildStatConfigs() {
        return this.buildStatConfigs;
    }

    public static Permission getRequiredPermission() {
        return Hudson.ADMINISTER;
    }

    public HistoricScale[] getHistoricScales() {
        return HistoricScale.values();
    }

    public YAxisChartType[] getYAxisChartTypes() {
        return YAxisChartType.values();
    }

    public List<JobBuildResult> getJobBuildResults() {
        return this.jobBuildResultsSharder.getJobBuildResults();
    }

    public JobBuildResultSharder getJobBuildResultsSharder() {
        return this.jobBuildResultsSharder;
    }

    public void reloadJobBuildResults(List<JobBuildResult> results) {
        this.jobBuildResultsSharder = new JobBuildResultSharder(this.jobBuildResultsSharder, results);
    }

    public List<RetentionStrategy> getAvailableRetentionStrategies() {
        return RetentionStrategy.values();
    }

    public boolean isStrategySelected(String strategyId) {
        return this.retentionStrategies.contains(RetentionStrategy.valueOf(strategyId));
    }

    public void setRetentionStrategies(List<RetentionStrategy> retentionStrategies) {
        this.retentionStrategies = retentionStrategies;
    }

    public List<RetentionStrategy> getRetentionStrategies() {
        return this.retentionStrategies;
    }

    public static class GlobalBuildStatsApi
    extends Api {
        public GlobalBuildStatsApi(Object bean) {
            super(bean);
        }

        public void doJson(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
            if (!GlobalBuildStatsApi.exposeChartData(req, rsp, Flavor.JSON)) {
                Jenkins.get().checkPermission(GlobalBuildStatsPlugin.getRequiredPermission());
                super.doJson(req, rsp);
            }
        }

        public void doPython(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
            if (!GlobalBuildStatsApi.exposeChartData(req, rsp, Flavor.PYTHON)) {
                Jenkins.get().checkPermission(GlobalBuildStatsPlugin.getRequiredPermission());
                super.doPython(req, rsp);
            }
        }

        public void doXml(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String xpath, @QueryParameter String wrapper, @QueryParameter String tree, @QueryParameter int depth) throws IOException, ServletException {
            if (!GlobalBuildStatsApi.exposeChartData(req, rsp, Flavor.XML)) {
                Jenkins.get().checkPermission(GlobalBuildStatsPlugin.getRequiredPermission());
                super.doXml(req, rsp, xpath, wrapper, tree, depth);
            }
        }

        private static boolean exposeChartData(StaplerRequest2 req, StaplerResponse2 rsp, Flavor flavor) throws ServletException, IOException {
            BuildStatConfiguration config;
            boolean chartDataHasBeenExposed = false;
            String buildStatConfigId = req.getParameter("buildStatConfigId");
            if (buildStatConfigId != null && (config = GlobalBuildStatsPlugin.getPluginBusiness().searchBuildStatConfigById(buildStatConfigId)) != null) {
                List<AbstractBuildStatChartDimension> dimensions = GlobalBuildStatsPlugin.getPluginBusiness().createDataSetBuilder(config);
                rsp.serveExposedBean(req, (Object)new BuildStatChartData(dimensions), flavor);
                chartDataHasBeenExposed = true;
            }
            return chartDataHasBeenExposed;
        }
    }

    @Extension
    public static class GlobalBuildStatsRunListener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> r, TaskListener listener) {
            LOGGER.log(Level.FINEST, "GlobalBuildStatsRunListener onCompleted " + r.getExternalizableId());
            GlobalBuildStatsPlugin.getPluginBusiness().onJobCompleted(r);
        }

        public void onDeleted(Run<?, ?> build) {
            GlobalBuildStatsPlugin.getPluginBusiness().onBuildDeleted(build);
        }
    }

    @Extension
    public static class GlobalBuildStatsManagementLink
    extends ManagementLink {
        public String getIconFileName() {
            return "symbol-bar-chart-outline plugin-ionicons-api";
        }

        public String getDisplayName() {
            return Messages.Global_Builds_Stats();
        }

        public String getUrlName() {
            return "plugin/global-build-stats/";
        }

        public String getDescription() {
            return Messages.Displays_stats_about_daily_build_results();
        }
    }

    @Extension
    public static class GlobalBuildStatsItemListener
    extends ItemListener {
        public void onLoaded() {
            super.onLoaded();
            GlobalBuildStatsPlugin.getPluginBusiness().reloadPlugin();
        }
    }
}

