/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.xstream.migration.v3;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.plugins.global_build_stats.xstream.migration.PreV8AbstractMigrator;
import hudson.plugins.global_build_stats.xstream.migration.v2.V2GlobalBuildStatsPOJO;
import hudson.plugins.global_build_stats.xstream.migration.v3.V3GlobalBuildStatsPOJO;
import java.util.ArrayList;
import java.util.List;

public class V2ToV3Migrator
extends PreV8AbstractMigrator<V2GlobalBuildStatsPOJO, V3GlobalBuildStatsPOJO> {
    @Override
    protected V3GlobalBuildStatsPOJO createMigratedPojo() {
        return new V3GlobalBuildStatsPOJO();
    }

    @Override
    protected List<JobBuildResult> migrateJobBuildResults(List<JobBuildResult> jobBuildResults) {
        ArrayList<JobBuildResult> migratedJobBuildResults = new ArrayList<JobBuildResult>();
        for (JobBuildResult jbr : jobBuildResults) {
            long duration = -1L;
            String nodeName = JobBuildResult.EMPTY_NODE_NAME;
            Run<?, ?> b = V2ToV3Migrator.retrieveBuildFromJobBuildResult(jbr);
            if (b != null) {
                duration = b.getDuration();
                nodeName = b instanceof AbstractBuild ? ((AbstractBuild)b).getBuiltOnStr() : "";
            }
            jbr.setDuration(duration);
            jbr.setNodeName(nodeName);
            migratedJobBuildResults.add(jbr);
        }
        return migratedJobBuildResults;
    }
}

