/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.global_build_stats.model.BuildResult;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Comparator;

public class JobBuildResult
implements Serializable {
    private static final long serialVersionUID = -4697202185011561179L;
    public static final long EMPTY_DURATION = -1L;
    public static final String EMPTY_NODE_NAME = null;
    public static final String EMPTY_USER_NAME = null;
    public static final String MASTER_NODE_NAME = "master";
    private BuildResult result;
    private String jobName;
    private int buildNumber;
    private Calendar buildDate;
    private long duration = -1L;
    private String nodeName;
    private String userName = null;

    public JobBuildResult(BuildResult _result, String _jobName, int _buildNumber, Calendar _buildDate, long duration, String nodeName, String _userName) {
        this.result = _result;
        this.jobName = _jobName;
        this.buildNumber = _buildNumber;
        this.buildDate = (Calendar)_buildDate.clone();
        this.duration = duration;
        this.setNodeName(nodeName);
        this.userName = _userName;
    }

    public String toString() {
        return "jobName=" + this.jobName + ", buildNumber=" + this.buildNumber + ", result=" + (Object)((Object)this.result) + ", buildDate=" + this.buildDate + ", duration=" + this.duration + ", nodeName=" + this.nodeName + ", userName=" + this.userName;
    }

    public BuildResult getResult() {
        return this.result;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Calendar getBuildDate() {
        return this.buildDate;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isJobBuiltOnMaster() {
        return MASTER_NODE_NAME.equals(this.nodeName);
    }

    public boolean isDurationEmpty() {
        return -1L == this.duration;
    }

    public boolean isUserNameEmpty() {
        return EMPTY_USER_NAME == this.userName;
    }

    public boolean isNodeNameEmpty() {
        return this.nodeName == EMPTY_NODE_NAME;
    }

    @SuppressFBWarnings(value={"HE_EQUALS_USE_HASHCODE"})
    public boolean equals(Object obj) {
        if (obj instanceof JobBuildResult) {
            JobBuildResult r = (JobBuildResult)obj;
            return this.is(r.buildNumber, r.jobName, r.result);
        }
        return false;
    }

    public boolean is(int buildNumber, String jobName, BuildResult result) {
        return buildNumber == this.buildNumber && jobName.equals(this.jobName) && result.equals((Object)this.result);
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = "".equals(nodeName) ? MASTER_NODE_NAME : nodeName;
    }

    public String getUserName() {
        return this.userName;
    }

    @SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public static class AntiChronologicalComparator
    extends ChronologicalComparator {
        @Override
        public int compare(JobBuildResult jbr1, JobBuildResult jbr2) {
            return super.compare(jbr1, jbr2) * -1;
        }
    }

    public static class ChronologicalComparator
    implements Comparator<JobBuildResult> {
        @Override
        public int compare(JobBuildResult jbr1, JobBuildResult jbr2) {
            return jbr1.buildDate.compareTo(jbr2.buildDate);
        }
    }
}

