/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Objects;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=3)
public class DateRange
implements Comparable<DateRange> {
    private Calendar start;
    private Calendar end;
    private DateFormat dateFormatter;

    public DateRange(Calendar _start, Calendar _end, DateFormat _dateFormatter) {
        this.start = (Calendar)_start.clone();
        this.end = (Calendar)_end.clone();
        this.dateFormatter = _dateFormatter;
    }

    @Override
    public int compareTo(DateRange o) {
        return this.start.compareTo(o.start);
    }

    public String toString() {
        return this.dateFormatter.format(this.start.getTime()) + " --> " + this.dateFormatter.format(this.end.getTime());
    }

    @Exported
    public Calendar getStart() {
        return this.start;
    }

    @Exported
    public Calendar getEnd() {
        return this.end;
    }

    public int hashCode() {
        return Objects.hashCode(this.start);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateRange other = (DateRange)obj;
        return Objects.equals(this.start, other.start);
    }
}

