/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.global_build_stats.Messages;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BuildResult {
    SUCCESS(1){

        @Override
        public String getLabel() {
            return Messages.Build_Results_Statuses_SUCCESS();
        }
    }
    ,
    FAILURE(2){

        @Override
        public String getLabel() {
            return Messages.Build_Results_Statuses_FAILURES();
        }
    }
    ,
    UNSTABLE(4){

        @Override
        public String getLabel() {
            return Messages.Build_Results_Statuses_UNSTABLES();
        }
    }
    ,
    ABORTED(8){

        @Override
        public String getLabel() {
            return Messages.Build_Results_Statuses_ABORTED();
        }
    }
    ,
    NOT_BUILD(16){

        @Override
        public String getLabel() {
            return Messages.Build_Results_Statuses_NOT_BUILD();
        }
    };

    @SuppressFBWarnings(value={"ME_MUTABLE_ENUM_FIELD"})
    public transient short code;

    private BuildResult(short _code) {
        this.code = _code;
    }

    public abstract String getLabel();

    public int getSuccessCount() {
        return this.code >> 0 & 1;
    }

    public int getFailureCount() {
        return this.code >> 1 & 1;
    }

    public int getUnstableCount() {
        return this.code >> 2 & 1;
    }

    public int getAbortedCount() {
        return this.code >> 3 & 1;
    }

    public int getNotBuildCount() {
        return this.code >> 4 & 1;
    }
}

