/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.business;

import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.global_build_stats.GlobalBuildStatsPlugin;
import hudson.plugins.global_build_stats.JobBuildResultFactory;
import hudson.plugins.global_build_stats.business.GlobalBuildStatsPluginSaver;
import hudson.plugins.global_build_stats.model.AbstractBuildStatChartDimension;
import hudson.plugins.global_build_stats.model.BuildHistorySearchCriteria;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.model.DateRange;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.plugins.global_build_stats.model.JobBuildSearchResult;
import hudson.plugins.global_build_stats.model.ModelIdGenerator;
import hudson.plugins.global_build_stats.model.YAxisChartDimension;
import hudson.plugins.global_build_stats.rententionstrategies.RetentionStrategy;
import hudson.plugins.global_build_stats.util.CollectionsUtil;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class GlobalBuildStatsBusiness {
    private static final Logger LOGGER = Logger.getLogger(GlobalBuildStatsBusiness.class.getName());
    final GlobalBuildStatsPluginSaver pluginSaver;
    final GlobalBuildStatsPlugin plugin;

    public GlobalBuildStatsBusiness(GlobalBuildStatsPlugin _plugin) {
        this.plugin = _plugin;
        this.pluginSaver = new GlobalBuildStatsPluginSaver(_plugin);
    }

    public void onJobCompleted(final Run<?, ?> build) {
        LOGGER.log(Level.FINEST, "GlobalBuildStatsBusiness onJobCompleted " + build.getExternalizableId());
        for (RetentionStrategy s : this.plugin.getRetentionStrategies()) {
            s.onBuildCompleted(build, this.pluginSaver);
        }
        this.pluginSaver.updatePlugin(new GlobalBuildStatsPluginSaver.BeforeSavePluginCallback(){

            @Override
            public void changePluginStateBeforeSavingIt(GlobalBuildStatsPlugin plugin) {
                plugin.getJobBuildResultsSharder().queueResultToAdd(JobBuildResultFactory.INSTANCE.createJobBuildResult(build));
            }
        });
    }

    public BuildStatConfiguration searchBuildStatConfigById(String buildStatId) {
        int index = this.searchBuildStatConfigIndexById(buildStatId);
        if (index != -1) {
            return this.plugin.getBuildStatConfigs().get(index);
        }
        return null;
    }

    private int searchBuildStatConfigIndexById(String id) {
        int idx = 0;
        for (BuildStatConfiguration c : this.plugin.getBuildStatConfigs()) {
            if (id.equals(c.getId())) break;
            ++idx;
        }
        if (idx == this.plugin.getBuildStatConfigs().size()) {
            idx = -1;
        }
        return idx;
    }

    public void recordBuildInfos() throws IOException {
        this.pluginSaver.updatePlugin(new GlobalBuildStatsPluginSaver.BeforeSavePluginCallback(){

            @Override
            public void changePluginStateBeforeSavingIt(GlobalBuildStatsPlugin plugin) {
                List jobBuildResultsRead = Hudson.get().getAllItems(Job.class).stream().map(job -> job).map(Job::getBuilds).flatMap(Collection::stream).map(JobBuildResultFactory.INSTANCE::createJobBuildResult).collect(Collectors.toList());
                plugin.getJobBuildResultsSharder().queueResultsToAdd(CollectionsUtil.minus(jobBuildResultsRead, plugin.getJobBuildResults()));
            }
        });
    }

    public JFreeChart createChart(BuildStatConfiguration config) {
        List<AbstractBuildStatChartDimension> dimensions = this.createDataSetBuilder(config);
        return this.createChart(dimensions, config.getBuildStatTitle());
    }

    public List<JobBuildSearchResult> searchBuilds(BuildHistorySearchCriteria searchCriteria) {
        ArrayList<JobBuildSearchResult> filteredJobBuildResults = new ArrayList<JobBuildSearchResult>();
        for (JobBuildResult r : this.plugin.getJobBuildResults()) {
            if (!searchCriteria.isJobResultEligible(r)) continue;
            filteredJobBuildResults.add(JobBuildResultFactory.INSTANCE.createJobBuildSearchResult(r));
        }
        Collections.sort(filteredJobBuildResults, new JobBuildResult.AntiChronologicalComparator());
        return filteredJobBuildResults;
    }

    public void updateBuildStatConfiguration(final String oldBuildStatId, final BuildStatConfiguration config, final boolean regenerateId) throws IOException {
        this.pluginSaver.updatePlugin(new GlobalBuildStatsPluginSaver.BeforeSavePluginCallback(){

            @Override
            public void changePluginStateBeforeSavingIt(GlobalBuildStatsPlugin plugin) {
                if (regenerateId) {
                    String newBuildStatId = ModelIdGenerator.INSTANCE.generateIdForClass(BuildStatConfiguration.class);
                    config.setId(newBuildStatId);
                }
                int buildStatIndex = GlobalBuildStatsBusiness.this.searchBuildStatConfigIndexById(oldBuildStatId);
                plugin.getBuildStatConfigs().set(buildStatIndex, config);
            }

            @Override
            public void afterPluginSaved() {
                if (regenerateId) {
                    ModelIdGenerator.INSTANCE.unregisterIdForClass(BuildStatConfiguration.class, oldBuildStatId);
                }
            }
        });
    }

    public void addBuildStatConfiguration(final BuildStatConfiguration config) throws IOException {
        this.pluginSaver.updatePlugin(new GlobalBuildStatsPluginSaver.BeforeSavePluginCallback(){

            @Override
            public void changePluginStateBeforeSavingIt(GlobalBuildStatsPlugin plugin) {
                plugin.getBuildStatConfigs().add(config);
            }
        });
    }

    public void deleteBuildStatConfiguration(final String buildStatId) throws IOException {
        this.pluginSaver.updatePlugin(new GlobalBuildStatsPluginSaver.BeforeSavePluginCallback(){

            @Override
            public void changePluginStateBeforeSavingIt(GlobalBuildStatsPlugin plugin) {
                int index = GlobalBuildStatsBusiness.this.searchBuildStatConfigIndexById(buildStatId);
                plugin.getBuildStatConfigs().remove(index);
            }
        });
    }

    public void moveUpConf(final String buildStatId) throws IOException {
        this.pluginSaver.updatePlugin(new GlobalBuildStatsPluginSaver.BeforeSavePluginCallback(){

            @Override
            public void changePluginStateBeforeSavingIt(GlobalBuildStatsPlugin plugin) {
                int index = GlobalBuildStatsBusiness.this.searchBuildStatConfigIndexById(buildStatId);
                if (index <= 0) {
                    throw new IllegalArgumentException("Can't move up first build stat configuration !");
                }
                BuildStatConfiguration b = plugin.getBuildStatConfigs().get(index);
                plugin.getBuildStatConfigs().set(index, plugin.getBuildStatConfigs().get(index - 1));
                plugin.getBuildStatConfigs().set(index - 1, b);
            }
        });
    }

    public void moveDownConf(final String buildStatId) throws IOException {
        this.pluginSaver.updatePlugin(new GlobalBuildStatsPluginSaver.BeforeSavePluginCallback(){

            @Override
            public void changePluginStateBeforeSavingIt(GlobalBuildStatsPlugin plugin) {
                int index = GlobalBuildStatsBusiness.this.searchBuildStatConfigIndexById(buildStatId);
                if (index >= plugin.getBuildStatConfigs().size() - 1) {
                    throw new IllegalArgumentException("Can't move down last build stat configuration !");
                }
                BuildStatConfiguration b = plugin.getBuildStatConfigs().get(index);
                plugin.getBuildStatConfigs().set(index, plugin.getBuildStatConfigs().get(index + 1));
                plugin.getBuildStatConfigs().set(index + 1, b);
            }
        });
    }

    public static String escapeAntiSlashes(String value) {
        if (value != null) {
            return value.replaceAll("\\\\", "\\\\\\\\");
        }
        return null;
    }

    private JFreeChart createChart(List<AbstractBuildStatChartDimension> dimensions, String title) {
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)title, null, (String)"", (CategoryDataset)new DataSetBuilder().build(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setForegroundAlpha(0.85f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.darkGray);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        for (int i = 0; i < dimensions.size(); ++i) {
            AbstractBuildStatChartDimension dimension = dimensions.get(dimensions.size() - 1 - i);
            plot.setRangeAxis(i, dimension.getRangeAxis());
            plot.setRenderer(i, dimension.getRenderer());
            plot.setDataset(i, dimension.getDatasetBuilder().build());
            plot.mapDatasetToRangeAxis(i, i);
        }
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private static LegendItemCollection sortLegendItems(LegendItemCollection legendItems) {
        LegendItemCollection sortedLegendItems = new LegendItemCollection();
        List<AbstractBuildStatChartDimension.LegendItemData> sortedLegendItemsLabels = AbstractBuildStatChartDimension.getSortedLegendItemsLabels();
        for (AbstractBuildStatChartDimension.LegendItemData legendItemData : sortedLegendItemsLabels) {
            Iterator legendItemsIter = legendItems.iterator();
            LegendItem legendItemMatchingCurrentLabel = null;
            while (legendItemMatchingCurrentLabel == null && legendItemsIter.hasNext()) {
                LegendItem currentLegendItem = (LegendItem)legendItemsIter.next();
                if (!legendItemData.label.equals(currentLegendItem.getLabel())) continue;
                legendItemMatchingCurrentLabel = new LegendItem(legendItemData.label, currentLegendItem.getDescription(), currentLegendItem.getToolTipText(), "", (Shape)new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0), (Paint)legendItemData.color);
            }
            if (legendItemMatchingCurrentLabel == null) continue;
            sortedLegendItems.add(legendItemMatchingCurrentLabel);
        }
        return sortedLegendItems;
    }

    public void updateRetentionStrategies(final List<RetentionStrategy> selectedStrategies) {
        this.pluginSaver.updatePlugin(new GlobalBuildStatsPluginSaver.BeforeSavePluginCallback(){

            @Override
            public void changePluginStateBeforeSavingIt(GlobalBuildStatsPlugin plugin) {
                plugin.setRetentionStrategies(selectedStrategies);
                for (RetentionStrategy s : selectedStrategies) {
                    s.strategyActivated(GlobalBuildStatsBusiness.this.pluginSaver);
                }
            }
        });
    }

    public List<AbstractBuildStatChartDimension> createDataSetBuilder(BuildStatConfiguration config) {
        ArrayList<AbstractBuildStatChartDimension> dimensions = new ArrayList<AbstractBuildStatChartDimension>();
        for (YAxisChartDimension dimensionShown : config.getDimensionsShown()) {
            dimensions.add(dimensionShown.createBuildStatChartDimension(config, (DataSetBuilder<String, DateRange>)new DataSetBuilder()));
        }
        ArrayList<JobBuildResult> sortedJobResults = new ArrayList<JobBuildResult>(this.plugin.getJobBuildResults());
        Collections.sort(sortedJobResults, new JobBuildResult.AntiChronologicalComparator());
        Calendar d2 = new GregorianCalendar();
        Calendar d1 = config.getHistoricScale().getPreviousStep(d2);
        int tickCount = 0;
        Iterator buildsIter = sortedJobResults.iterator();
        JobBuildResult currentBuild = null;
        Calendar buildDate = new GregorianCalendar();
        buildDate.setTimeInMillis(1L);
        if (buildsIter.hasNext()) {
            currentBuild = (JobBuildResult)buildsIter.next();
            buildDate = currentBuild.getBuildDate();
        }
        while (tickCount != config.getHistoricLength()) {
            while (tickCount < config.getHistoricLength() && d1.after(buildDate)) {
                DateRange range = new DateRange(d1, d2, config.getHistoricScale().getDateRangeFormatter());
                for (AbstractBuildStatChartDimension dimension : dimensions) {
                    dimension.provideDataInDataSet(range);
                }
                d2 = (Calendar)d1.clone();
                d1 = config.getHistoricScale().getPreviousStep(d2);
                ++tickCount;
            }
            if (tickCount == config.getHistoricLength() || currentBuild == null) continue;
            if (config.getBuildFilters().isJobResultEligible(currentBuild)) {
                for (AbstractBuildStatChartDimension dimension : dimensions) {
                    dimension.saveDataForBuild(currentBuild);
                }
            }
            if (buildsIter.hasNext()) {
                currentBuild = (JobBuildResult)buildsIter.next();
                buildDate = currentBuild.getBuildDate();
                continue;
            }
            currentBuild = null;
            buildDate = new GregorianCalendar();
            buildDate.setTimeInMillis(1L);
        }
        return dimensions;
    }

    protected static List<JobBuildResult> mergeJobBuildResults(List<JobBuildResult> existingJobResults, List<JobBuildResult> jobResultsToMerge) {
        ArrayList<JobBuildResult> mergedJobResultsList = new ArrayList<JobBuildResult>(existingJobResults);
        for (JobBuildResult jbrToMerge : jobResultsToMerge) {
            if (mergedJobResultsList.contains(jbrToMerge)) continue;
            mergedJobResultsList.add(jbrToMerge);
        }
        return mergedJobResultsList;
    }

    public void reloadPlugin() {
        this.pluginSaver.reloadPlugin();
        if (this.plugin.getJobBuildResults() == null || this.plugin.getJobBuildResults().isEmpty()) {
            try {
                this.recordBuildInfos();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void onBuildDeleted(Run<?, ?> build) {
        for (RetentionStrategy s : this.plugin.getRetentionStrategies()) {
            s.onBuildDeleted(build, this.pluginSaver);
        }
    }
}

