/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats;

import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.global_build_stats.model.BuildResult;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.plugins.global_build_stats.model.JobBuildSearchResult;
import jenkins.model.Jenkins;

public class JobBuildResultFactory {
    public static final JobBuildResultFactory INSTANCE = new JobBuildResultFactory();
    private static final String SYSTEM_USERNAME = "SYSTEM";

    private JobBuildResultFactory() {
    }

    public JobBuildResult createJobBuildResult(Run<?, ?> build) {
        String buildName = build.getParent().getFullName();
        long duration = build.getDuration();
        String nodeName = build instanceof AbstractBuild ? ((AbstractBuild)build).getBuiltOnStr() : "";
        return new JobBuildResult(this.createBuildResult(build.getResult()), buildName, build.getNumber(), build.getTimestamp(), duration, nodeName, JobBuildResultFactory.extractUserNameIn(build));
    }

    public JobBuildSearchResult createJobBuildSearchResult(Run<?, ?> build) {
        return this.createJobBuildSearchResult(this.createJobBuildResult(build));
    }

    public JobBuildSearchResult createJobBuildSearchResult(JobBuildResult r) {
        boolean isJobAccessible = false;
        boolean isBuildAccessible = false;
        String jobUrl = "";
        Job targetJob = (Job)Jenkins.getInstance().getItemByFullName(r.getJobName());
        if (targetJob != null) {
            isJobAccessible = true;
            jobUrl = targetJob.getUrl();
            if (targetJob.getBuildByNumber(r.getBuildNumber()) != null) {
                isBuildAccessible = true;
            }
        }
        return new JobBuildSearchResult(r, isJobAccessible, isBuildAccessible, jobUrl);
    }

    public static String extractUserNameIn(Run<?, ?> build) {
        Cause.UserCause uc = (Cause.UserCause)build.getCause(Cause.UserCause.class);
        Cause.UserIdCause uic = (Cause.UserIdCause)build.getCause(Cause.UserIdCause.class);
        String userName = uc != null ? uc.getUserName() : (uic != null ? uic.getUserId() : SYSTEM_USERNAME);
        return userName;
    }

    public BuildResult createBuildResult(Result result) {
        if (Result.ABORTED.equals(result)) {
            return BuildResult.ABORTED;
        }
        if (Result.FAILURE.equals(result)) {
            return BuildResult.FAILURE;
        }
        if (Result.NOT_BUILT.equals(result)) {
            return BuildResult.NOT_BUILD;
        }
        if (Result.SUCCESS.equals(result)) {
            return BuildResult.SUCCESS;
        }
        return BuildResult.UNSTABLE;
    }
}

