/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitlablogo;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.Secret;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.models.Project;
import org.jenkinsci.plugins.gitlablogo.GitlabLogoProjectCache;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class GitlabLogoProperty
extends JobProperty<Job<?, ?>> {
    private final String repositoryName;

    @DataBoundConstructor
    public GitlabLogoProperty(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public boolean isAvailable() {
        return StringUtils.isNotEmpty((String)this.repositoryName);
    }

    public boolean isDefaultIcon() {
        return StringUtils.isEmpty((String)this.getIconUrl());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getIconUrl() {
        Project project = this.getProject();
        if (project == null) {
            return "";
        }
        return project.getAvatarUrl();
    }

    public String getRepositoryUrl() {
        Project project = this.getProject();
        if (project == null) {
            return "";
        }
        return project.getWebUrl();
    }

    private Project getProject() {
        return GitlabLogoProjectCache.PROJECT_CACHE.computeIfAbsent(this.getRepositoryName(), name -> {
            DescriptorImpl descriptor = this.getDescriptor();
            GitLabApi gitLabApi = new GitLabApi(descriptor.getEndpointUrl(), descriptor.getPrivateToken().getPlainText());
            ProjectApi projectApi = gitLabApi.getProjectApi();
            try {
                return projectApi.getProject(name);
            }
            catch (GitLabApiException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private Secret privateToken;
        private String endpointUrl;

        public DescriptorImpl() {
            super(GitlabLogoProperty.class);
            super.load();
        }

        public String getDisplayName() {
            return "GitLab logo";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public GitlabLogoProperty newInstance(@NonNull StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return (GitlabLogoProperty)((Object)req.bindJSON(GitlabLogoProperty.class, formData));
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            this.privateToken = Secret.fromString((String)formData.getString("privateToken"));
            this.endpointUrl = formData.getString("endpointUrl");
            this.save();
            return super.configure(req, formData);
        }

        public Secret getPrivateToken() {
            return this.privateToken;
        }

        public String getEndpointUrl() {
            return this.endpointUrl;
        }

        public void doClearCache(StaplerRequest2 req, StaplerResponse2 rsp) {
            GitlabLogoProjectCache.PROJECT_CACHE.clear();
        }
    }
}

