/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitlablogo;

import hudson.Extension;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.gitlablogo.GitlabLogoProperty;

@Extension(optional=true)
public class GitLabAvatarContributor {
    private static final Logger LOGGER = Logger.getLogger(GitLabAvatarContributor.class.getName());

    public String getUrlAllowList() {
        String endpointUrl;
        GitlabLogoProperty.DescriptorImpl descriptor;
        HashSet<Object> allowedDomains = new HashSet<Object>();
        allowedDomains.add("https://gitlab.com");
        allowedDomains.add("https://*.gitlab.com");
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null && (descriptor = (GitlabLogoProperty.DescriptorImpl)jenkins.getDescriptorByType(GitlabLogoProperty.DescriptorImpl.class)) != null && (endpointUrl = descriptor.getEndpointUrl()) != null && !endpointUrl.isEmpty()) {
            try {
                URL url = new URL(endpointUrl);
                String domain = url.getProtocol() + "://" + url.getHost();
                if (url.getPort() != -1 && url.getPort() != 80 && url.getPort() != 443) {
                    domain = domain + ":" + url.getPort();
                }
                allowedDomains.add(domain);
                LOGGER.fine("Adding self-hosted GitLab domain to CSP allowlist: " + domain);
            }
            catch (MalformedURLException e) {
                LOGGER.warning("Invalid GitLab endpoint URL in configuration: " + endpointUrl);
            }
        }
        return String.join((CharSequence)" ", allowedDomains);
    }
}

