/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.jenkins.githubprcoveragestatus;

import com.github.terma.jenkins.githubprcoveragestatus.CoverageReportParser;
import com.github.terma.jenkins.githubprcoveragestatus.JsonUtils;
import com.jayway.jsonpath.JsonPathException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class SimpleCovParser
implements CoverageReportParser {
    private static final String METRIC_PATH = "$.metrics.covered_percent";

    @Override
    public float get(String simpleCovFilePath) {
        String content;
        try {
            content = FileUtils.readFileToString((File)new File(simpleCovFilePath));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't read SimpleCov report by path: " + simpleCovFilePath);
        }
        Double covered = this.extractValueFromPath(content);
        return covered.floatValue() / 100.0f;
    }

    private Double extractValueFromPath(String content) {
        try {
            return (Double)JsonUtils.findInJson(content, METRIC_PATH);
        }
        catch (JsonPathException error) {
            throw new IllegalArgumentException("Strange SimpleCov report!\nCan't extract float value by JsonPath: $.metrics.covered_percent\nfrom:\n" + content);
        }
    }
}

