/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.jenkins.githubprcoveragestatus;

import com.github.terma.jenkins.githubprcoveragestatus.BuildMasterCoverageRepository;
import com.github.terma.jenkins.githubprcoveragestatus.Configuration;
import com.github.terma.jenkins.githubprcoveragestatus.CoverageRepository;
import com.github.terma.jenkins.githubprcoveragestatus.GetCoverageCallable;
import com.github.terma.jenkins.githubprcoveragestatus.GitHubPullRequestRepository;
import com.github.terma.jenkins.githubprcoveragestatus.MasterCoverageRepository;
import com.github.terma.jenkins.githubprcoveragestatus.PullRequestRepository;
import com.github.terma.jenkins.githubprcoveragestatus.SettingsRepository;
import com.github.terma.jenkins.githubprcoveragestatus.SonarMasterCoverageRepository;
import java.io.PrintStream;

public class ServiceRegistry {
    private static MasterCoverageRepository masterCoverageRepository;
    private static CoverageRepository coverageRepository;
    private static SettingsRepository settingsRepository;
    private static PullRequestRepository pullRequestRepository;

    public static MasterCoverageRepository getMasterCoverageRepository(PrintStream buildLog, String login, String password) {
        if (masterCoverageRepository != null) {
            return masterCoverageRepository;
        }
        if (Configuration.isUseSonarForMasterCoverage().booleanValue()) {
            String sonarUrl = Configuration.getSonarUrl();
            if (login != null && password != null) {
                buildLog.println("take master coverage from sonar by login/password");
                return new SonarMasterCoverageRepository(sonarUrl, login, password, buildLog);
            }
            if (Configuration.getSonarToken() != null) {
                buildLog.println("take master coverage from sonar by token");
                return new SonarMasterCoverageRepository(sonarUrl, Configuration.getSonarToken(), "", buildLog);
            }
            buildLog.println("take master coverage from sonar by login/password");
            return new SonarMasterCoverageRepository(sonarUrl, Configuration.getSonarLogin(), Configuration.getSonarPassword(), buildLog);
        }
        buildLog.println("use default coverage repo");
        return new BuildMasterCoverageRepository(buildLog);
    }

    public static void setMasterCoverageRepository(MasterCoverageRepository masterCoverageRepository) {
        ServiceRegistry.masterCoverageRepository = masterCoverageRepository;
    }

    public static CoverageRepository getCoverageRepository(boolean disableSimpleCov, String jacocoCoverageCounter) {
        return coverageRepository != null ? coverageRepository : new GetCoverageCallable(disableSimpleCov, jacocoCoverageCounter);
    }

    public static void setCoverageRepository(CoverageRepository coverageRepository) {
        ServiceRegistry.coverageRepository = coverageRepository;
    }

    public static SettingsRepository getSettingsRepository() {
        return settingsRepository != null ? settingsRepository : Configuration.DESCRIPTOR;
    }

    public static void setSettingsRepository(SettingsRepository settingsRepository) {
        ServiceRegistry.settingsRepository = settingsRepository;
    }

    public static PullRequestRepository getPullRequestRepository() {
        return pullRequestRepository != null ? pullRequestRepository : new GitHubPullRequestRepository();
    }

    public static void setPullRequestRepository(PullRequestRepository pullRequestRepository) {
        ServiceRegistry.pullRequestRepository = pullRequestRepository;
    }
}

