/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.jenkins.githubprcoveragestatus;

import com.github.terma.jenkins.githubprcoveragestatus.ServiceRegistry;
import hudson.EnvVars;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import org.kohsuke.github.GHPullRequest;

public class PrIdAndUrlUtils {
    public static final String GIT_URL_PROPERTY = "GIT_URL";
    public static final String GIT_PR_ID_ENV_PROPERTY = "ghprbPullId";
    public static final String CHANGE_ID_PROPERTY = "CHANGE_ID";
    public static final String CHANGE_URL_PROPERTY = "CHANGE_URL";

    private PrIdAndUrlUtils() {
        throw new UnsupportedOperationException("Util class!");
    }

    private static Integer getPullRequestBuilder(Run build, TaskListener listener) throws IOException, InterruptedException {
        EnvVars envVars = build.getEnvironment(listener);
        String gitPrId = (String)envVars.get((Object)GIT_PR_ID_ENV_PROPERTY);
        String changeId = (String)envVars.get((Object)CHANGE_ID_PROPERTY);
        String idString = gitPrId != null ? gitPrId : changeId;
        return idString != null ? Integer.valueOf(Integer.parseInt(idString)) : null;
    }

    private static Integer getMultiBranch(Map<String, String> scmVars, TaskListener listener) throws IOException {
        if (scmVars == null) {
            return null;
        }
        PrintStream buildLog = listener.getLogger();
        String url = scmVars.get(GIT_URL_PROPERTY);
        String branch = scmVars.get("GIT_BRANCH");
        String sha = scmVars.get("GIT_COMMIT");
        buildLog.println("[GitHub PR Status] " + String.format("Attempt to discover PR for %s @ %s", branch, sha));
        GHPullRequest gitPr = ServiceRegistry.getPullRequestRepository().getPullRequestFor(url, branch, sha);
        int id = gitPr.getNumber();
        buildLog.println("[GitHub PR Status] " + String.format("Discovered PR %d", id));
        return id;
    }

    public static int getPrId(Map<String, String> scmVars, Run build, TaskListener listener) throws IOException, InterruptedException {
        Integer id = PrIdAndUrlUtils.getPullRequestBuilder(build, listener);
        if (id == null) {
            id = PrIdAndUrlUtils.getMultiBranch(scmVars, listener);
        }
        if (id == null) {
            throw new UnsupportedOperationException("Can't find ghprbPullId or scmVars in build variables!");
        }
        return id;
    }

    public static String getGitUrl(Map<String, String> scmVars, Run build, TaskListener listener) throws IOException, InterruptedException {
        EnvVars envVars = build.getEnvironment(listener);
        String gitUrl = (String)envVars.get(GIT_URL_PROPERTY);
        String changeUrl = (String)envVars.get(CHANGE_URL_PROPERTY);
        if (scmVars != null && scmVars.containsKey(GIT_URL_PROPERTY)) {
            return scmVars.get(GIT_URL_PROPERTY);
        }
        if (gitUrl != null) {
            return gitUrl;
        }
        if (changeUrl != null) {
            return changeUrl;
        }
        throw new UnsupportedOperationException("Can't find GIT_URL or CHANGE_URL in envs: " + envVars);
    }
}

