/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.jenkins.githubprcoveragestatus;

import com.github.terma.jenkins.githubprcoveragestatus.Percent;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

class Message {
    private static final String BADGE_TEMPLATE = "https://img.shields.io/badge/coverage-%s-%s.svg";
    private static final String COLOR_RED = "red";
    private static final String COLOR_YELLOW = "yellow";
    private static final String COLOR_GREEN = "brightgreen";
    private final float coverage;
    private final float masterCoverage;

    public Message(float coverage, float masterCoverage) {
        this.coverage = Percent.roundFourAfterDigit(coverage);
        this.masterCoverage = Percent.roundFourAfterDigit(masterCoverage);
    }

    public String forConsole() {
        return String.format("Coverage %s changed %s vs master %s", Percent.toWholeNoSignString(this.coverage), Percent.toString(Percent.change(this.coverage, this.masterCoverage)), Percent.toWholeNoSignString(this.masterCoverage));
    }

    public String forComment(String buildUrl, String jenkinsUrl, int yellowThreshold, int greenThreshold, boolean useShieldsIo) {
        String icon = this.forIcon();
        if (useShieldsIo) {
            return "[![" + icon + "](" + this.shieldIoUrl(icon, yellowThreshold, greenThreshold) + ")](" + buildUrl + ")";
        }
        return "[![" + icon + "](" + jenkinsUrl + "/coverage-status-icon/?coverage=" + this.coverage + "&masterCoverage=" + this.masterCoverage + ")](" + buildUrl + ")";
    }

    public String forStatusCheck() {
        return String.format("Coverage %s changed %s vs master %s", Percent.toWholeNoSignString(this.coverage), Percent.toString(Percent.change(this.coverage, this.masterCoverage)), Percent.toWholeNoSignString(this.masterCoverage));
    }

    private String shieldIoUrl(String icon, int yellowThreshold, int greenThreshold) {
        String color = this.getColor(yellowThreshold, greenThreshold);
        icon = icon.replace("-", "--");
        try {
            return String.format(BADGE_TEMPLATE, URIUtil.encodePath((String)icon), color);
        }
        catch (URIException e) {
            throw new RuntimeException(e);
        }
    }

    private String getColor(int yellowThreshold, int greenThreshold) {
        String color = COLOR_GREEN;
        int coveragePercent = Percent.of(this.coverage);
        if (coveragePercent < yellowThreshold) {
            color = COLOR_RED;
        } else if (coveragePercent < greenThreshold) {
            color = COLOR_YELLOW;
        }
        return color;
    }

    public String forIcon() {
        return String.format("%s (%s) vs master %s", Percent.toWholeNoSignString(this.coverage), Percent.toString(Percent.change(this.coverage, this.masterCoverage)), Percent.toWholeNoSignString(this.masterCoverage));
    }
}

