/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.jenkins.githubprcoveragestatus;

import com.github.terma.jenkins.githubprcoveragestatus.Configuration;
import com.github.terma.jenkins.githubprcoveragestatus.Percent;
import com.github.terma.jenkins.githubprcoveragestatus.PrIdAndUrlUtils;
import com.github.terma.jenkins.githubprcoveragestatus.ServiceRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MasterCoverageAction
extends Recorder
implements SimpleBuildStep {
    public static final String DISPLAY_NAME = "Record Master Coverage";
    private static final long serialVersionUID = 1L;
    private Map<String, String> scmVars;
    private String jacocoCounterType;

    @DataBoundConstructor
    public MasterCoverageAction() {
    }

    public Map<String, String> getScmVars() {
        return this.scmVars;
    }

    @DataBoundSetter
    public void setScmVars(Map<String, String> scmVars) {
        this.scmVars = scmVars;
    }

    @DataBoundSetter
    public void setJacocoCounterType(String jacocoCounterType) {
        this.jacocoCounterType = jacocoCounterType;
    }

    public String getJacocoCounterType() {
        return this.jacocoCounterType;
    }

    public void perform(Run build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        if (build.getResult() != Result.SUCCESS) {
            return;
        }
        PrintStream buildLog = listener.getLogger();
        String gitUrl = PrIdAndUrlUtils.getGitUrl(this.scmVars, build, listener);
        boolean disableSimpleCov = ServiceRegistry.getSettingsRepository().isDisableSimpleCov();
        String jacocoCounterType = this.jacocoCounterType;
        float masterCoverage = ServiceRegistry.getCoverageRepository(disableSimpleCov, jacocoCounterType).get(workspace);
        buildLog.println("Master coverage " + Percent.toWholeString(masterCoverage));
        Configuration.setMasterCoverage(gitUrl, masterCoverage);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @NonNull
        public String getDisplayName() {
            return MasterCoverageAction.DISPLAY_NAME;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

