/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.jenkins.githubprcoveragestatus;

import com.github.terma.jenkins.githubprcoveragestatus.CoverageReportParser;
import com.github.terma.jenkins.githubprcoveragestatus.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

class JacocoParser
implements CoverageReportParser {
    private List<String> coverageCounters = new ArrayList<String>(){
        {
            this.add("instruction");
            this.add("complexity");
            this.add("method");
            this.add("class");
            this.add("line");
        }
    };
    private String coverageCounterType = "";

    public JacocoParser(String coverageCounterType) {
        this.coverageCounterType = coverageCounterType;
    }

    private float getByXpath(String filePath, String content, String xpath) {
        try {
            return Float.parseFloat(XmlUtils.findInXml(content, xpath));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Strange Jacoco report!\nFile path: " + filePath + "\nCan't extract float value by XPath: " + xpath + "\nfrom:\n" + content);
        }
    }

    @Override
    public float get(String jacocoFilePath) {
        String content;
        try {
            content = FileUtils.readFileToString((File)new File(jacocoFilePath));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't read Jacoco report by path: " + jacocoFilePath);
        }
        if (!this.isValidCoverageCounter(this.coverageCounterType)) {
            this.coverageCounterType = this.coverageCounters.get(0);
        }
        float missed = this.getByXpath(jacocoFilePath, content, this.getMissedXpath(this.coverageCounterType));
        float covered = this.getByXpath(jacocoFilePath, content, this.getCoverageXpath(this.coverageCounterType));
        float coverage = covered + missed;
        if (coverage == 0.0f) {
            return 0.0f;
        }
        return covered / coverage;
    }

    private boolean isValidCoverageCounter(String coverageCounter) {
        if (coverageCounter == null) {
            return false;
        }
        for (String type : this.coverageCounters) {
            if (!type.equalsIgnoreCase(coverageCounter)) continue;
            return true;
        }
        return false;
    }

    private String getMissedXpath(String counterType) {
        return "/report/counter[@type='" + counterType.toUpperCase() + "']/@missed";
    }

    private String getCoverageXpath(String counterType) {
        return "/report/counter[@type='" + counterType.toUpperCase() + "']/@covered";
    }
}

