/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.jenkins.githubprcoveragestatus;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitUtils {
    public static final Pattern HTTP_GITHUB_USER_REPO_PATTERN = Pattern.compile("^(http[s]?://[^/]*)/([^/]*/[^/]*).*");
    public static final Pattern SSH_GITHUB_USER_REPO_PATTERN = Pattern.compile("^.+:(.+)");

    public static String getRepoName(String gitRepoUrl) {
        String[] userRepo = GitUtils.getUserRepo(gitRepoUrl).split("/");
        if (userRepo.length < 2) {
            throw new IllegalArgumentException("Bad Git repository URL: " + gitRepoUrl);
        }
        return userRepo[1];
    }

    public static String getUserRepo(String gitRepoUrl) {
        String userRepo = null;
        if (gitRepoUrl != null) {
            Matcher m = HTTP_GITHUB_USER_REPO_PATTERN.matcher(gitRepoUrl);
            if (m.matches()) {
                userRepo = m.group(2);
            }
            if (userRepo == null && (m = SSH_GITHUB_USER_REPO_PATTERN.matcher(gitRepoUrl)).matches()) {
                userRepo = m.group(1);
            }
        }
        if (userRepo == null) {
            throw new IllegalStateException(String.format("Invalid Git Hub repository URL: %s", gitRepoUrl));
        }
        if (userRepo.endsWith(".git")) {
            userRepo = userRepo.substring(0, userRepo.length() - ".git".length());
        }
        return userRepo;
    }
}

