/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.jenkins.githubprcoveragestatus;

import com.github.terma.jenkins.githubprcoveragestatus.GitUtils;
import com.github.terma.jenkins.githubprcoveragestatus.PullRequestRepository;
import com.github.terma.jenkins.githubprcoveragestatus.ServiceRegistry;
import com.github.terma.jenkins.githubprcoveragestatus.SettingsRepository;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

public class GitHubPullRequestRepository
implements PullRequestRepository {
    @Override
    public GHPullRequest getPullRequestFor(String gitHubUrl, String branch, String sha) throws IOException {
        for (GHPullRequest pr : this.getGitHubRepository(gitHubUrl).getPullRequests(GHIssueState.OPEN)) {
            if (!pr.getHead().getRef().equals(branch) || !pr.getHead().getSha().equals(sha)) continue;
            return pr;
        }
        throw new IOException(String.format("No PR found for %s %s @ %s", gitHubUrl, branch, sha));
    }

    @Override
    public GHRepository getGitHubRepository(String gitHubUrl) throws IOException {
        GitHub gitHub = GitHubPullRequestRepository.getGitHub();
        try {
            if (gitHub.getRateLimit().remaining == 0) {
                throw new IOException("Exceeded rate limit for repository");
            }
        }
        catch (FileNotFoundException ex) {
            throw new IOException("Rate limit API not found.");
        }
        catch (IOException ex) {
            throw new IOException("Error while accessing rate limit API", ex);
        }
        String userRepo = GitUtils.getUserRepo(gitHubUrl);
        try {
            return gitHub.getRepository(userRepo);
        }
        catch (IOException ex) {
            throw new IOException("Could not retrieve GitHub repository named " + userRepo + " (Do you have properly set 'GitHub project' field in job configuration?)", ex);
        }
    }

    private static GitHub getGitHub() throws IOException {
        SettingsRepository settingsRepository = ServiceRegistry.getSettingsRepository();
        String apiUrl = settingsRepository.getGitHubApiUrl();
        String personalAccessToken = settingsRepository.getPersonalAccessToken();
        if (apiUrl != null) {
            if (personalAccessToken != null) {
                return GitHub.connectToEnterprise((String)apiUrl, (String)personalAccessToken);
            }
            return GitHub.connectToEnterpriseAnonymously((String)apiUrl);
        }
        if (personalAccessToken != null) {
            return GitHub.connectUsingOAuth((String)personalAccessToken);
        }
        return GitHub.connectAnonymously();
    }

    @Override
    public void comment(GHRepository ghRepository, int prId, String message) throws IOException {
        ghRepository.getPullRequest(prId).comment(message);
    }

    @Override
    public void createCommitStatus(GHRepository ghRepository, String sha1, GHCommitState state, String targetUrl, String description) throws IOException {
        ghRepository.createCommitStatus(sha1, state, targetUrl, description, "test-coverage-plugin");
    }
}

