/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.jenkins.githubprcoveragestatus;

import com.github.terma.jenkins.githubprcoveragestatus.CloverParser;
import com.github.terma.jenkins.githubprcoveragestatus.CoberturaParser;
import com.github.terma.jenkins.githubprcoveragestatus.CoverageReportParser;
import com.github.terma.jenkins.githubprcoveragestatus.CoverageRepository;
import com.github.terma.jenkins.githubprcoveragestatus.JacocoParser;
import com.github.terma.jenkins.githubprcoveragestatus.SimpleCovParser;
import hudson.FilePath;
import hudson.Util;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

final class GetCoverageCallable
extends MasterToSlaveFileCallable<Float>
implements CoverageRepository {
    private final boolean disableSimpleCov;
    private String jacocoCounterType = "";

    GetCoverageCallable(boolean disableSimpleCov, String jacocoCounterType) {
        this.disableSimpleCov = disableSimpleCov;
        this.jacocoCounterType = jacocoCounterType;
    }

    private List<Float> getFloats(File ws, String path, CoverageReportParser parser) {
        FileSet fs = Util.createFileSet((File)ws, (String)path);
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] files = ds.getIncludedFiles();
        ArrayList<Float> cov = new ArrayList<Float>();
        for (String file : files) {
            cov.add(Float.valueOf(parser.get(new File(ds.getBasedir(), file).getAbsolutePath())));
        }
        return cov;
    }

    @Override
    public float get(FilePath workspace) throws IOException, InterruptedException {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace should not be null!");
        }
        return ((Float)workspace.act((FilePath.FileCallable)new GetCoverageCallable(this.disableSimpleCov, this.jacocoCounterType))).floatValue();
    }

    public Float invoke(File ws, VirtualChannel channel) {
        ArrayList<Float> cov = new ArrayList<Float>();
        cov.addAll(this.getFloats(ws, "**/cobertura.xml", new CoberturaParser()));
        cov.addAll(this.getFloats(ws, "**/cobertura-coverage.xml", new CoberturaParser()));
        cov.addAll(this.getFloats(ws, "**/jacoco.xml", new JacocoParser(this.jacocoCounterType)));
        cov.addAll(this.getFloats(ws, "**/jacocoTestReport.xml", new JacocoParser(this.jacocoCounterType)));
        cov.addAll(this.getFloats(ws, "**/clover.xml", new CloverParser()));
        if (!this.disableSimpleCov) {
            cov.addAll(this.getFloats(ws, "**/coverage.json", new SimpleCovParser()));
        }
        float s = 0.0f;
        Iterator iterator = cov.iterator();
        while (iterator.hasNext()) {
            float v = ((Float)iterator.next()).floatValue();
            s += v;
        }
        if (cov.isEmpty()) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(s / (float)cov.size());
    }
}

