/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.jenkins.githubprcoveragestatus;

import com.github.terma.jenkins.githubprcoveragestatus.Configuration;
import com.github.terma.jenkins.githubprcoveragestatus.Message;
import com.github.terma.jenkins.githubprcoveragestatus.Percent;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class CoverageStatusIconAction
implements UnprotectedRootAction {
    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "coverage-status-icon";
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        float coverage = Float.parseFloat(request.getParameter("coverage"));
        float masterCoverage = Float.parseFloat(request.getParameter("masterCoverage"));
        response.setContentType("image/svg+xml");
        String svg = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/com/github/terma/jenkins/githubprcoveragestatus/Icon/icon.svg"));
        Message message = new Message(coverage, masterCoverage);
        svg = StringUtils.replace((String)svg, (String)"{{ message }}", (String)message.forIcon());
        int coveragePercent = Percent.of(coverage);
        String color = coveragePercent < Configuration.getYellowThreshold() ? "#b94947" : (coveragePercent < Configuration.getGreenThreshold() ? "#F89406" : "#97CA00");
        svg = StringUtils.replace((String)svg, (String)"{{ color }}", (String)color);
        response.getWriter().write(svg);
    }
}

