/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.jenkins.githubprcoveragestatus;

import com.github.terma.jenkins.githubprcoveragestatus.SettingsRepository;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.Secret;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.json.JSONObject;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class Configuration
extends AbstractDescribableImpl<Configuration> {
    @Extension
    public static final ConfigurationDescriptor DESCRIPTOR = new ConfigurationDescriptor();

    @DataBoundConstructor
    public Configuration() {
    }

    public static String getGitHubApiUrl() {
        return DESCRIPTOR.getGitHubApiUrl();
    }

    public static int getYellowThreshold() {
        return DESCRIPTOR.getYellowThreshold();
    }

    public static int getGreenThreshold() {
        return DESCRIPTOR.getGreenThreshold();
    }

    public static String getPersonalAccessToken() {
        return DESCRIPTOR.getPersonalAccessToken();
    }

    public static String getSonarUrl() {
        return DESCRIPTOR.getSonarUrl();
    }

    public static String getSonarToken() {
        return DESCRIPTOR.getSonarToken();
    }

    public static String getSonarLogin() {
        return DESCRIPTOR.getSonarLogin();
    }

    public static String getSonarPassword() {
        return DESCRIPTOR.getSonarPassword();
    }

    public static Boolean isUseSonarForMasterCoverage() {
        return DESCRIPTOR.isUseSonarForMasterCoverage();
    }

    public static void setMasterCoverage(String repo, float coverage) {
        DESCRIPTOR.set(repo, coverage);
    }

    public ConfigurationDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class ConfigurationDescriptor
    extends Descriptor<Configuration>
    implements SettingsRepository {
        private static final int DEFAULT_YELLOW_THRESHOLD = 80;
        private static final int DEFAULT_GREEN_THRESHOLD = 90;
        private final Map<String, Float> coverageByRepo = new ConcurrentHashMap<String, Float>();
        private boolean disableSimpleCov;
        private String gitHubApiUrl;
        private String personalAccessToken;
        private String jenkinsUrl;
        private boolean privateJenkinsPublicGitHub;
        private boolean useSonarForMasterCoverage;
        private String sonarUrl;
        private String sonarToken;
        private String sonarLogin;
        private String sonarPassword;
        private int yellowThreshold = 80;
        private int greenThreshold = 90;

        public ConfigurationDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return "Coverage status for GitHub Pull Requests";
        }

        @NonNull
        public Map<String, Float> getCoverageByRepo() {
            return this.coverageByRepo;
        }

        public void set(String repo, float coverage) {
            this.coverageByRepo.put(repo, Float.valueOf(coverage));
            this.save();
        }

        @Override
        public String getGitHubApiUrl() {
            return this.gitHubApiUrl;
        }

        @Override
        public String getPersonalAccessToken() {
            return this.personalAccessToken;
        }

        @Override
        public int getYellowThreshold() {
            return this.yellowThreshold;
        }

        @Override
        public int getGreenThreshold() {
            return this.greenThreshold;
        }

        @Override
        public boolean isPrivateJenkinsPublicGitHub() {
            return this.privateJenkinsPublicGitHub;
        }

        @Override
        public boolean isUseSonarForMasterCoverage() {
            return this.useSonarForMasterCoverage;
        }

        @Override
        public boolean isDisableSimpleCov() {
            return this.disableSimpleCov;
        }

        @Override
        public String getSonarUrl() {
            return this.sonarUrl;
        }

        @Override
        public String getSonarToken() {
            return this.sonarToken;
        }

        @Override
        public String getJenkinsUrl() {
            return this.jenkinsUrl;
        }

        public String getSonarLogin() {
            return this.sonarLogin;
        }

        public String getSonarPassword() {
            return this.sonarPassword;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.gitHubApiUrl = StringUtils.trimToNull((String)formData.getString("gitHubApiUrl"));
            this.personalAccessToken = Secret.toString((Secret)Secret.fromString((String)StringUtils.trimToNull((String)formData.getString("personalAccessToken"))));
            this.yellowThreshold = NumberUtils.toInt((String)formData.getString("yellowThreshold"), (int)80);
            this.greenThreshold = NumberUtils.toInt((String)formData.getString("greenThreshold"), (int)90);
            this.jenkinsUrl = StringUtils.trimToNull((String)formData.getString("jenkinsUrl"));
            this.privateJenkinsPublicGitHub = BooleanUtils.toBoolean((String)formData.getString("privateJenkinsPublicGitHub"));
            this.useSonarForMasterCoverage = BooleanUtils.toBoolean((String)formData.getString("useSonarForMasterCoverage"));
            this.disableSimpleCov = BooleanUtils.toBoolean((String)formData.getString("disableSimpleCov"));
            this.sonarUrl = StringUtils.trimToNull((String)formData.getString("sonarUrl"));
            this.sonarToken = Secret.toString((Secret)Secret.fromString((String)StringUtils.trimToNull((String)formData.getString("sonarToken"))));
            this.sonarLogin = StringUtils.trimToNull((String)formData.getString("sonarLogin"));
            this.sonarPassword = Secret.toString((Secret)Secret.fromString((String)StringUtils.trimToNull((String)formData.getString("sonarPassword"))));
            this.save();
            return super.configure(req, formData);
        }
    }
}

